/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import java.util.HashMap;

public enum ExpirationHintType {
    NULL(-1),
    Parent(0),
    FixedExpiration(1),
    TTLExpiration(2),
    TTLIdleExpiration(3),
    FixedIdleExpiration(4),
    FileDependency(5),
    KeyDependency(6),
    NodeExpiration(7),
    SqlCacheDependency(8),
    Sql7CacheDependency(9),
    SqlYukonCacheDependency(10),
    OracleCacheDependency(11),
    IdleExpiration(12),
    AggregateExpirationHint(13),
    DBCacheDependency(14),
    DependencyHint(15),
    OleDbCacheDependency(16),
    ExtensibleDependency(17);

    private static HashMap<Integer, ExpirationHintType> mappings;
    private int intValue;

    private ExpirationHintType(int value) {
        this.intValue = value;
        ExpirationHintType.getMappings().put(value, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, ExpirationHintType> getMappings() {
        if (mappings != null) return mappings;
        Class<ExpirationHintType> clazz = ExpirationHintType.class;
        synchronized (ExpirationHintType.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    public static ExpirationHintType forValue(int value) {
        return ExpirationHintType.getMappings().get(value);
    }

    public int getValue() {
        return this.intValue;
    }
}

