/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.DBCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.ExtensibleDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FileDependency;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.FixedIdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IExpirationEventSink;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.AutoExpiration.NodeExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.OleDbCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.OracleCacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.Sql7CacheDependency;
import Alachisoft.NCache.Caching.AutoExpiration.TTLExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.TTLIdleExpiration;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.EventArgs;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import tangible.RefObject;

public abstract class ExpirationHint
implements Comparable,
IDisposable,
ICompactSerializable {
    public static final int EXPIRED = 1;
    public static final int NEEDS_RESYNC = 2;
    public static final int IS_VARIANT = 4;
    public static final int NON_ROUTABLE = 8;
    public static final int DISPOSED = 16;
    public ExpirationHintType _hintType = ExpirationHintType.Parent;
    public ILogger _ncacheLog = null;
    private String _cacheKey;
    private int _bits;
    private IExpirationEventSink _objNotify;

    protected ExpirationHint() {
    }

    public static ExpirationHint ReadExpHint(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        ExpirationHintType expHint = ExpirationHintType.Parent;
        expHint = ExpirationHintType.forValue(reader.readShort());
        ExpirationHint tmpObj = null;
        switch (expHint) {
            case NULL: {
                return null;
            }
            case Parent: {
                tmpObj = (ExpirationHint)reader.readObject();
                return tmpObj;
            }
            case FixedExpiration: {
                FixedExpiration fe = new FixedExpiration();
                fe.deserialize(reader);
                return fe;
            }
            case TTLExpiration: {
                TTLExpiration ttle = new TTLExpiration();
                ttle.deserialize(reader);
                return ttle;
            }
            case TTLIdleExpiration: {
                TTLIdleExpiration ttlie = new TTLIdleExpiration();
                ttlie.deserialize(reader);
                return ttlie;
            }
            case FixedIdleExpiration: {
                FixedIdleExpiration fie = new FixedIdleExpiration();
                fie.deserialize(reader);
                return fie;
            }
            case FileDependency: {
                FileDependency fd = new FileDependency();
                fd.deserialize(reader);
                return fd;
            }
            case KeyDependency: {
                KeyDependency kd = new KeyDependency();
                kd.deserialize(reader);
                return kd;
            }
            case NodeExpiration: {
                NodeExpiration ne = new NodeExpiration();
                ne.deserialize(reader);
                return ne;
            }
            case Sql7CacheDependency: {
                Sql7CacheDependency s7cd = new Sql7CacheDependency();
                s7cd.deserialize(reader);
                return s7cd;
            }
            case OleDbCacheDependency: {
                OleDbCacheDependency oledbDependency = new OleDbCacheDependency();
                oledbDependency.deserialize(reader);
                return oledbDependency;
            }
            case OracleCacheDependency: {
                OracleCacheDependency orclcd = new OracleCacheDependency();
                orclcd.deserialize(reader);
                return orclcd;
            }
            case IdleExpiration: {
                IdleExpiration ie = new IdleExpiration();
                ie.deserialize(reader);
                return ie;
            }
            case AggregateExpirationHint: {
                AggregateExpirationHint aeh = new AggregateExpirationHint();
                aeh.deserialize(reader);
                return aeh;
            }
            case DBCacheDependency: {
                DBCacheDependency dbcd = new DBCacheDependency();
                dbcd.deserialize(reader);
                return dbcd;
            }
            case ExtensibleDependency: {
                ExtensibleDependency ed = new ExtensibleDependency();
                ed = (ExtensibleDependency)reader.readObject();
                return ed;
            }
            case DependencyHint: {
                break;
            }
        }
        return null;
    }

    public static void WriteExpHint(NCacheObjectOutput writer, ExpirationHint expHint) throws IOException {
        if (expHint == null) {
            writer.writeShort((int)((short)ExpirationHintType.NULL.getValue()));
            return;
        }
        writer.writeShort((int)((short)expHint._hintType.getValue()));
        if (expHint._hintType == ExpirationHintType.ExtensibleDependency) {
            writer.writeObject((Object)expHint);
        } else {
            expHint.serialize(writer);
        }
    }

    public void dispose() {
        this.SetBit(16);
        this.DisposeInternal();
    }

    protected void DisposeInternal() {
    }

    public abstract int getSortKey();

    public final ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final boolean getHasExpired() {
        return this.IsBitSet(1);
    }

    public final boolean getNeedsReSync() {
        return this.IsBitSet(2);
    }

    public final boolean getIsVariant() {
        return this.IsBitSet(4);
    }

    public final boolean getIsRoutable() {
        return !this.IsBitSet(8);
    }

    public final boolean getIsDisposed() {
        return this.IsBitSet(16);
    }

    public String getCacheKey() {
        return this._cacheKey;
    }

    public void setCacheKey(String value) {
        this._cacheKey = value;
    }

    public boolean DetermineExpiration(CacheRuntimeContext context) {
        return this.getHasExpired();
    }

    public boolean CheckExpired(CacheRuntimeContext context) {
        return false;
    }

    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        this._bits &= 0xFFFFFFFE;
        if (this._ncacheLog == null) {
            this._ncacheLog = context.getNCacheLog();
        }
        return true;
    }

    public void ResetVariant(CacheRuntimeContext context) throws OperationFailedException {
        if (this.getIsVariant()) {
            this.Reset(context);
        }
    }

    protected final void SetExpirationEventSink(IExpirationEventSink objNotify) {
        this._objNotify = objNotify;
    }

    protected final void NotifyExpiration(Object sender, EventArgs e) {
        IExpirationEventSink changed1;
        if (this.SetBit(1) && (changed1 = this._objNotify) != null) {
            changed1.DependentExpired(sender, e);
        }
    }

    public final boolean IsBitSet(int bit) {
        return (this._bits & bit) != 0;
    }

    public boolean SetBit(int bit) {
        int oldBits = this._bits;
        if ((oldBits & bit) != 0) {
            return false;
        }
        RefObject tempRef__bits = new RefObject((Object)this._bits);
        AtomicInteger atom = new AtomicInteger(this._bits);
        boolean val = atom.compareAndSet(oldBits, oldBits | bit);
        this._bits = atom.get();
        return val;
    }

    public int compareTo(Object obj) {
        if (obj instanceof ExpirationHint) {
            return new Integer(this.getSortKey()).compareTo(((ExpirationHint)obj).getSortKey());
        }
        return 1;
    }

    public boolean ReInitializeHint(CacheRuntimeContext context) {
        return false;
    }

    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._hintType = (ExpirationHintType)((Object)reader.readObject());
        this._bits = reader.readInt();
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeObject((Object)this._hintType);
        writer.writeInt(this._bits);
    }
}

