/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.license;

import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.license.ActivationStatus;
import com.alachisoft.ncache.ncactivate.license.ByteRef;
import com.alachisoft.ncache.ncactivate.license.NCCrypto;
import com.alachisoft.ncache.ncactivate.license.NCFileUtil;
import com.alachisoft.ncache.ncactivate.license.SystemTime;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.ncactivate.utils.StringRef;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.LocalVerificationFailedException;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NCMisc {
    public static final String winStub = RegUtil.winStub;
    public static final String linuxStub = RegUtil.linuxStub;
    public static int g_DataOffset = 4104;

    static void TimeStampData(byte[] dataPtr, long dwSize, int extensions, int period, int version) {
        int offset = 0;
        offset += g_DataOffset;
        offset += 16;
        SystemTime pSysTime = new SystemTime();
        NCMisc.WriteWordToByteArray(pSysTime.wYear, dataPtr, offset += 16 * version);
        NCMisc.WriteWordToByteArray(pSysTime.wMonth, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray(pSysTime.wDay, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)extensions, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)0, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)period, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)ActivationStatus.Eval.getOrdinal(ActivationStatus.Eval), dataPtr, offset += 2);
        offset += 2;
        ByteRef dataPtr1 = new ByteRef();
        dataPtr1.data = dataPtr;
        NCCrypto.EncryptDecryptBytes(dataPtr1, (int)(dwSize - (long)g_DataOffset), g_DataOffset);
    }

    static void TimeStampData(byte[] dataPtr, long dwSize, int extensions, int period, int version, ActivationStatus activationStatus) throws LicensingException {
        int offset = 0;
        offset += g_DataOffset;
        offset += 16;
        SystemTime pSysTime = new SystemTime();
        NCMisc.WriteWordToByteArray(pSysTime.wYear, dataPtr, offset += 16 * version);
        NCMisc.WriteWordToByteArray(pSysTime.wMonth, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray(pSysTime.wDay, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)extensions, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)0, dataPtr, offset += 2);
        NCMisc.WriteWordToByteArray((short)period, dataPtr, offset += 2);
        offset += 2;
        if (pSysTime.wSecond != ActivationStatus.Activated.getOrdinal(ActivationStatus.Activated) || pSysTime.wSecond == ActivationStatus.Deactivated.getOrdinal(ActivationStatus.Deactivated)) {
            pSysTime.wSecond = (short)activationStatus.getOrdinal(activationStatus);
            NCMisc.WriteWordToByteArray(pSysTime.wSecond, dataPtr, offset);
            offset += 2;
        } else {
            NCMisc.WriteWordToByteArray(pSysTime.wSecond, dataPtr, offset);
            offset += 2;
        }
        ByteRef dataPtr1 = new ByteRef();
        dataPtr1.data = dataPtr;
        NCCrypto.EncryptDecryptBytes(dataPtr1, (int)(dwSize - (long)g_DataOffset), g_DataOffset);
    }

    static void UpdateActivationStatus(byte[] dataPtr, long dwSize, int version, ActivationStatus activationStatus) {
        int offset = 0;
        offset += g_DataOffset;
        offset += 16;
        offset += 16 * version;
        NCMisc.WriteWordToByteArray((short)activationStatus.getOrdinal(activationStatus), dataPtr, offset += 12);
        offset += 2;
        ByteRef dataPtr1 = new ByteRef();
        dataPtr1.data = dataPtr;
        NCCrypto.EncryptDecryptBytes(dataPtr1, (int)(dwSize - (long)g_DataOffset), g_DataOffset);
    }

    public static void GetInstallTime(byte[] data, long version, SystemTime pSysTime) throws LicensingException {
        int offset = 0;
        if (data != null) {
            offset = (int)((long)offset + ((long)g_DataOffset + 16L * version));
            pSysTime.wYear = NCMisc.ReadWordFromByteArray(data, offset);
            pSysTime.wMonth = NCMisc.ReadWordFromByteArray(data, offset += 2);
            pSysTime.wMonth = (short)(pSysTime.wMonth - 1);
            pSysTime.wDayOfWeek = NCMisc.ReadWordFromByteArray(data, offset += 2);
            pSysTime.wDay = NCMisc.ReadWordFromByteArray(data, offset += 2);
            pSysTime.wHour = NCMisc.ReadWordFromByteArray(data, offset += 2);
            pSysTime.wMinute = NCMisc.ReadWordFromByteArray(data, offset += 2);
            pSysTime.wSecond = NCMisc.ReadWordFromByteArray(data, offset += 2);
            offset += 2;
        }
    }

    public static boolean IsValidVersionMark(byte[] data, int version) throws LicensingException {
        int offset = 0;
        offset += g_DataOffset;
        offset += 16;
        SystemTime pSysTime = new SystemTime();
        pSysTime.wYear = NCMisc.ReadWordFromByteArray(data, offset += version * 16);
        pSysTime.wMonth = NCMisc.ReadWordFromByteArray(data, offset += 2);
        pSysTime.wDay = NCMisc.ReadWordFromByteArray(data, offset += 2);
        pSysTime.wMinute = NCMisc.ReadWordFromByteArray(data, offset += 2);
        offset += 2;
        if (pSysTime.wYear < 2005 || pSysTime.wYear > 3500) {
            return false;
        }
        return pSysTime.wMonth <= 12 && pSysTime.wDay <= 31;
    }

    public static boolean IsValidVersionMark(SystemTime pSysTime) {
        if (pSysTime.wYear < 2005 || pSysTime.wYear > 3500) {
            return false;
        }
        return pSysTime.wMonth <= 12 && pSysTime.wDay <= 31;
    }

    public static int ReadIntFromByteArray(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static short ReadWordFromByteArray(byte[] b, int offset) throws LicensingException {
        short shortVal = 0;
        try {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.put(b[offset]);
            bb.put(b[offset + 1]);
            shortVal = bb.getShort(0);
        }
        catch (Exception ex) {
            throw new LicensingException("Unable to find file containing evaluation data");
        }
        return shortVal;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static void WriteIntToByteArray(int value, byte[] data, int arrOffset) {
        int i = 0;
        while (i < 4) {
            int offset = (3 - i) * 8;
            data[arrOffset] = (byte)(value >>> offset & 0xFF);
            ++i;
            ++arrOffset;
        }
    }

    public static void WriteWordToByteArray(short value, byte[] data, int arrOffset) {
        int i = 0;
        while (i < 2) {
            int offset = (1 - i) * 8;
            data[arrOffset] = (byte)(value >>> offset & 0xFF);
            ++i;
            ++arrOffset;
        }
    }

    public static byte[] ReadEvaluationData() throws LicensingException {
        String[] systemFolder = null;
        RuntimeUtil.OS currentOS = RuntimeUtil.getCurrentOS();
        try {
            systemFolder = NCMisc.getStubPath();
        }
        catch (Exception ex) {
            throw new LicensingException("Unable to find file containing evaluation data");
        }
        ByteRef data = null;
        for (int i = 0; i < systemFolder.length; ++i) {
            boolean dwSize = false;
            boolean fileExists = NCFileUtil.FileExists(systemFolder[i]);
            if (!fileExists) continue;
            data = NCFileUtil.ReadFile(systemFolder[i], false);
            if (data == null) {
                throw new LicensingException("Unable to read file containing evaluation data");
            }
            if (data.data == null) {
                throw new LicensingException("Unable to read file containing evaluation data");
            }
            return data.data;
        }
        return null;
    }

    public static int ReadEvaluationData(long version, SystemTime pSysTime) throws LicensingException, LocalVerificationFailedException {
        String[] systemFolder = NCMisc.getStubPath();
        ByteRef data = NCMisc.ReadEvaluationData(systemFolder);
        return NCMisc.ReadEvaluationData(data.data, version, pSysTime);
    }

    public static int ReadEvaluationData(byte[] evalData, long version, SystemTime pSysTime) throws LicensingException {
        NCMisc.GetInstallTime(evalData, version, pSysTime);
        if (!NCMisc.IsValidVersionMark(pSysTime)) {
            throw new LicensingException("Valid evaluation data not found. Version mark missing");
        }
        try {
            RegUtil.LoadRegistry();
            AppUtil app = new AppUtil();
            pSysTime.wHour = (short)app.getExtensionsUsed();
        }
        catch (MissingResourceException mre) {
            pSysTime.wHour = 0;
        }
        return 0;
    }

    public static ByteRef ReadEvaluationData(String[] systemFolder) throws LicensingException, LocalVerificationFailedException {
        ByteRef data = null;
        int i = 0;
        if (i < systemFolder.length) {
            boolean dwSize = false;
            boolean fileExists = NCFileUtil.FileExists(systemFolder[i]);
            if (fileExists) {
                data = NCFileUtil.ReadFile(systemFolder[i]);
                if (data == null) {
                    throw new LicensingException("Invalid Authentication Code: Stage 007");
                }
                if (data.data == null) {
                    throw new LicensingException("Invalid Authentication Code: Stage 008");
                }
            } else {
                throw new LocalVerificationFailedException("Failed to load info, contacting local server.");
            }
        }
        return data;
    }

    public static String[] getStubPath() throws LicensingException {
        String[] systemFolder = null;
        RuntimeUtil.OS currentOS = RuntimeUtil.getCurrentOS();
        try {
            if (currentOS == RuntimeUtil.OS.Windows) {
                String sys32Folder = System.getenv("WINDIR") + "\\system32";
                systemFolder = new String[]{sys32Folder};
                for (int i = 0; i < systemFolder.length; ++i) {
                    systemFolder[i] = systemFolder[i] + "\\" + winStub;
                }
            } else {
                systemFolder = new String[]{"//usr//lib//" + linuxStub, "//usr//bin//" + linuxStub};
            }
        }
        catch (Exception ex) {
            throw new LicensingException("Unable to find file containing evaluation data");
        }
        return systemFolder;
    }

    public static void ReadActivationCode(StringRef dectext) {
        String dec;
        RegUtil.LoadRegistry();
        StringRef authCode = new StringRef();
        authCode.strData = RegUtil.getKey((InfoType)InfoType.LICENSE, (RegKeys)RegKeys.AuthCode);
        dectext.strData = dec = NCCrypto.EDecode(authCode);
        return;
    }

    private static String[] getWinSystemDir(String delim, String prop) {
        StringTokenizer tokanizer = new StringTokenizer(prop);
        Vector<String> v = new Vector<String>();
        String token = "";
        while (tokanizer.hasMoreTokens()) {
            token = tokanizer.nextToken(";");
            if (token.indexOf(delim) == -1 || v.contains(token)) continue;
            v.add(token);
        }
        return v.toArray(new String[0]);
    }

    public boolean allowEvalVerification() {
        try {
            String[] stringArray = NCMisc.getStubPath();
        }
        catch (LicensingException licensingException) {
            // empty catch block
        }
        return false;
    }
}

