/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.activate.cmdline;

import com.alachisoft.ncache.activate.cmdline.ActivateArgs;
import com.alachisoft.ncache.ncactivate.cmdline.LicenseTool;
import com.alachisoft.ncache.ncactivate.cmdline.exceptions.CorruptInstallationException;
import com.alachisoft.ncache.ncactivate.crypto.Crypto;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.ncactivate.utils.StringRef;
import com.alachisoft.ncache.ncactivate.utils.WebUtil;
import com.alachisoft.ncache.ncactivate.utils.XmlUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

public class ActivateTool
extends LicenseTool {
    @Override
    public void Run(String[] args) {
        if (super.intialize(args, new ActivateArgs())) {
            super.pringLogo();
            if (!super.printUsage()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.Run();
            }
        }
    }

    @Override
    protected void Run() {
        RegUtil.LoadRegistry();
        ActivateArgs cmdArgs = (ActivateArgs)super.getCmdArgs();
        super.getAppUtil();
        AppUtil.getProductInfo().LicenseKey = this.getValue(cmdArgs.getLicenseKey());
        super.getAppUtil().getUserInfo().FirstName = this.getValue(cmdArgs.getfName());
        super.getAppUtil().getUserInfo().LastName = this.getValue(cmdArgs.getlName());
        super.getAppUtil().getUserInfo().EmailAddr = this.getValue(cmdArgs.getEmail());
        super.getAppUtil().getUserInfo().Company = this.getValue(cmdArgs.getCompany());
        super.getAppUtil();
        AppUtil.getProductInfo().Reactivation = cmdArgs.getReactivate();
        super.getAppUtil().getUserInfo().City = this.getValue(cmdArgs.getCity());
        super.getAppUtil().getUserInfo().State = this.getValue(cmdArgs.getState());
        super.getAppUtil().getUserInfo().Country = this.getValue(cmdArgs.getCountry());
        super.getAppUtil().getUserInfo().Zip = this.getValue(cmdArgs.getZip());
        super.getAppUtil().getUserInfo().Phone = this.getValue(cmdArgs.getPhone());
        if (cmdArgs.getAuthCode() != null) {
            try {
                super.getAppUtil();
                AppUtil.VerifyResult result = AppUtil.VerifAuthKey(cmdArgs.getAuthCode());
                if (result != AppUtil.VerifyResult.Success) {
                    System.out.println("Invalid activation key specified");
                }
                super.getAppUtil().Activate(cmdArgs.getAuthCode());
                System.out.println("Product has been activated successfully. Execute verifylicense tool for further verification.");
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            HashMap<String, String> requiredParams = new HashMap<String, String>();
            requiredParams.put("first name", cmdArgs.getfName());
            requiredParams.put("last name", cmdArgs.getlName());
            requiredParams.put("license key", cmdArgs.getLicenseKey());
            requiredParams.put("email", cmdArgs.getEmail());
            if (super.checkRequiredParams(requiredParams)) {
                if (cmdArgs.getManual().booleanValue()) {
                    System.out.println("Please copy the following code and email to Alachisoft sales personnel or to sales@alachisoft.com \n\n" + super.getMachineInfoCode());
                    super.getAppUtil();
                    AppUtil.getActivationData().Save();
                    RegUtil.StoreRegistry();
                } else if (this.onlineActivation() > 0) {
                    super.getAppUtil();
                    AppUtil.getActivationData().User.Save();
                }
            }
        }
    }

    private String getValue(String arg) {
        return arg == null ? "" : arg;
    }

    private int onlineActivation() {
        String strHeaders = new String("Content-Type: application/x-www-form-urlencoded\r\n");
        super.getAppUtil();
        if (!AppUtil.getProductInfo().Reactivation) {
            super.getAppUtil();
            AppUtil.getProductInfo().ActId = EnvironmentUtil.NewGUID();
        }
        super.getAppUtil();
        String actXml = AppUtil.getActivationData().ToLinearText();
        super.getAppUtil();
        String edition = AppUtil.getActivationData().Product.Edition;
        String strFormData = String.format("activationText=%s&Edition=%s", WebUtil.UrlEncode(Crypto.Encode(actXml)), edition);
        System.out.println("Contacting license server...");
        try {
            char tmpChar;
            URL postUrl = new URL("http://app.alachisoft.com/activate/activate.php");
            HttpURLConnection con = (HttpURLConnection)postUrl.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Host", "app.alachisoft.com");
            con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Content-Length", String.valueOf(strFormData.length()));
            DataOutputStream connOut = new DataOutputStream(con.getOutputStream());
            connOut.writeBytes(strFormData);
            connOut.flush();
            connOut.close();
            int rc = con.getResponseCode();
            String strMsg = super.getStringTableProps().getProperty(String.valueOf(rc + 1000));
            if (rc >= 400 && rc <= 599) {
                System.out.println("Request/Server Error: Status Code = " + String.valueOf(rc));
                System.out.println("Message: " + strMsg);
                return -1;
            }
            System.out.println("Status Code = " + String.valueOf(rc));
            System.out.println("Message: " + strMsg + "\n");
            System.out.println("Requesting validation...");
            System.out.println("Waiting for status...");
            DataInputStream connIn = new DataInputStream(con.getInputStream());
            BufferedReader d = new BufferedReader(new InputStreamReader(connIn));
            while (!d.ready()) {
            }
            Object serverResp = new String("");
            char noChar = '\uffff';
            do {
                tmpChar = (char)d.read();
                serverResp = (String)serverResp + tmpChar;
            } while (tmpChar != noChar);
            StringRef extractedMessage = new StringRef();
            XmlUtil.ExtractFromXML("<text>", (String)serverResp, extractedMessage);
            if (((String)serverResp).indexOf("<error>") != -1) {
                System.out.println("\n" + extractedMessage.strData);
                return -2;
            }
            StringRef szAuthKey = new StringRef();
            XmlUtil.ExtractFromXML("<auth-key>", (String)serverResp, szAuthKey);
            super.getAppUtil();
            AppUtil.VerifyResult result = AppUtil.VerifAuthKey(szAuthKey.strData);
            if (result != AppUtil.VerifyResult.Success) {
                System.out.println("Invalid activation key specified");
                return -3;
            }
            if (super.getAppUtil().Activate(szAuthKey.strData) == 0) {
                System.out.println("\n" + extractedMessage.strData + "\n");
            }
        }
        catch (Exception e) {
            System.out.println("Connection failed: " + e.getMessage());
            return -4;
        }
        return 1;
    }
}

