/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Key;
import java.lang.reflect.Type;
import java.util.Map;
import org.weakref.jmx.guice.ObjectNameFunction;

class MapMapping<K, V> {
    private final ObjectNameFunction<Map.Entry<K, V>> objectNameFunction;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    MapMapping(Class<K> keyClass, Class<V> valueClass, ObjectNameFunction<Map.Entry<K, V>> objectNameFunction) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.objectNameFunction = objectNameFunction;
    }

    private static <K, V> Type mapOf(Class<K> keyClass, Class<V> valueClass) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyClass)).where(new TypeParameter<V>(){}, TypeToken.of(valueClass)).getType();
    }

    public ObjectNameFunction<Map.Entry<K, V>> getObjectNameFunction() {
        return this.objectNameFunction;
    }

    public Key<Map<K, V>> getKey() {
        return Key.get((Type)MapMapping.mapOf(this.keyClass, this.valueClass));
    }
}

