/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.weakref.jmx.AnnotationUtils;
import org.weakref.jmx.MBeanOperation;
import org.weakref.jmx.ReflectionMBeanOperation;

public class MBeanOperationBuilder {
    private Object target;
    private String name;
    private Method concreteMethod;
    private Method annotatedMethod;

    public MBeanOperationBuilder onInstance(Object target) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        this.target = target;
        return this;
    }

    public MBeanOperationBuilder named(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        return this;
    }

    public MBeanOperationBuilder withConcreteMethod(Method concreteMethod) {
        if (concreteMethod == null) {
            throw new NullPointerException("concreteMethod is null");
        }
        this.concreteMethod = concreteMethod;
        return this;
    }

    public MBeanOperationBuilder withAnnotatedMethod(Method annotatedMethod) {
        if (annotatedMethod == null) {
            throw new NullPointerException("annotatedMethod is null");
        }
        this.annotatedMethod = annotatedMethod;
        return this;
    }

    public MBeanOperation build() {
        if (this.target == null) {
            throw new IllegalArgumentException("JmxOperation must have a target object");
        }
        if (this.concreteMethod == null) {
            throw new IllegalArgumentException("JmxOperation must have a concrete method");
        }
        String operationName = this.name;
        if (operationName == null) {
            operationName = this.concreteMethod.getName();
        }
        BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
        String[] parameterNames = paranamer.lookupParameterNames((AccessibleObject)this.concreteMethod);
        Class<?>[] types = this.concreteMethod.getParameterTypes();
        Object parameterAnnotations = this.annotatedMethod != null ? this.annotatedMethod.getParameterAnnotations() : new Annotation[this.annotatedMethod.getParameterTypes().length][];
        MBeanParameterInfo[] parameterInfos = new MBeanParameterInfo[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            Descriptor parameterDescriptor = AnnotationUtils.buildDescriptor(parameterAnnotations[i]);
            String parameterDescription = AnnotationUtils.getDescription(parameterDescriptor, parameterAnnotations[i]);
            parameterInfos[i] = new MBeanParameterInfo(parameterNames[i], types[i].getName(), parameterDescription, parameterDescriptor);
        }
        Descriptor descriptor = null;
        if (this.annotatedMethod != null) {
            descriptor = AnnotationUtils.buildDescriptor(this.annotatedMethod);
        }
        String description = AnnotationUtils.getDescription(descriptor, this.annotatedMethod);
        MBeanOperationInfo mbeanOperationInfo = new MBeanOperationInfo(operationName, description, parameterInfos, this.concreteMethod.getReturnType().getName(), 3, descriptor);
        return new ReflectionMBeanOperation(mbeanOperationInfo, this.target, this.concreteMethod);
    }
}

