/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jmx2snmp.jmx;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.vafer.jmx2snmp.jmx.JmxAttribute;

public final class JmxIndex {
    private final AtomicReference<Map<String, JmxAttribute>> attributesRef = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
    private final MBeanServer mbeanServer;
    public String nodeName;
    private String expression;

    public JmxIndex() throws Exception {
        this(ManagementFactory.getPlatformMBeanServer(), "bean:*");
    }

    public JmxIndex(String pExpression) throws Exception {
        this(ManagementFactory.getPlatformMBeanServer(), pExpression);
    }

    public JmxIndex(MBeanServer pMbeanServer, String pExpression) throws Exception {
        this.mbeanServer = pMbeanServer;
        this.expression = pExpression;
    }

    public JmxIndex(String nodeName, String pExpression) throws Exception {
        this(nodeName, ManagementFactory.getPlatformMBeanServer(), pExpression);
    }

    public JmxIndex(String nodeName, MBeanServer pMbeanServer, String pExpression) throws Exception {
        this.mbeanServer = pMbeanServer;
        this.expression = pExpression;
        this.nodeName = nodeName;
        this.update();
    }

    public void update() throws Exception {
        HashMap<String, JmxAttribute> newAttributes = new HashMap<String, JmxAttribute>();
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(new ObjectName(this.expression), null);
        for (ObjectInstance mbean : mbeans) {
            MBeanAttributeInfo[] attributes;
            MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(mbean.getObjectName());
            for (MBeanAttributeInfo attribute : attributes = mbeanInfo.getAttributes()) {
                if (!attribute.isReadable()) continue;
                String attributeName = attribute.getName();
                JmxAttribute jmxAttribute = new JmxAttribute(attributeName, attribute.getType(), mbean.getObjectName(), this.mbeanServer);
                Object path = jmxAttribute.getPath();
                path = ((String)path).contains("<oid>.tayzgrid.client") ? ((String)path).substring(0, ((String)path).indexOf("." + this.nodeName)) + ((String)path).substring(((String)path).lastIndexOf(".")) : ((String)path).replace(this.nodeName + ".", "");
                newAttributes.put((String)path, jmxAttribute);
            }
        }
        this.attributesRef.set(Collections.unmodifiableMap(newAttributes));
    }

    public void dynamicUpdate(String pExpression) throws Exception {
        if (pExpression != null || !pExpression.isEmpty()) {
            this.expression = pExpression;
        }
        HashMap<String, JmxAttribute> newAttributes = new HashMap<String, JmxAttribute>();
        newAttributes.putAll(this.attributesRef.get());
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(new ObjectName(this.expression), null);
        for (ObjectInstance mbean : mbeans) {
            MBeanAttributeInfo[] attributes;
            MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(mbean.getObjectName());
            for (MBeanAttributeInfo attribute : attributes = mbeanInfo.getAttributes()) {
                String attributeName;
                JmxAttribute jmxAttribute;
                if (!attribute.isReadable() || newAttributes.containsKey((jmxAttribute = new JmxAttribute(attributeName = attribute.getName(), attribute.getType(), mbean.getObjectName(), this.mbeanServer)).getPath())) continue;
                newAttributes.put(jmxAttribute.getPath(), jmxAttribute);
            }
        }
        this.attributesRef.set(Collections.unmodifiableMap(newAttributes));
    }

    public Set<String> getAttributePaths() {
        Map<String, JmxAttribute> mapping = this.attributesRef.get();
        return Collections.unmodifiableSet(mapping.keySet());
    }

    public JmxAttribute getAttributeAtPath(String pPath) {
        Map<String, JmxAttribute> attributes = this.attributesRef.get();
        return attributes.get(pPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append('{').append(this.attributesRef.get()).append('}');
        return sb.toString();
    }
}

