/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.monitoring;

import Alachisoft.NCache.Common.DataStructures.Enumerator;
import Alachisoft.NCache.Common.DataStructures.SlidingIndex;
import com.alachisoft.ncache.common.monitoring.IntervalCounterDataCollection;
import com.alachisoft.ncache.common.monitoring.MutableKeyValuePair;
import java.util.ArrayList;
import tangible.RefObject;

public class MonitorableEntitiesDataStore
implements AutoCloseable {
    private SlidingIndex<MutableKeyValuePair<IntervalCounterDataCollection, Boolean>> _statsIndex;
    private SlidingIndex<Object> _logIndex;

    public MonitorableEntitiesDataStore(int interval) {
        this._statsIndex = new SlidingIndex(interval);
        this._logIndex = new SlidingIndex(interval);
    }

    public final void AddCounterData(IntervalCounterDataCollection CounterDataCollection2) {
        MutableKeyValuePair<IntervalCounterDataCollection, Boolean> tempVar = new MutableKeyValuePair<IntervalCounterDataCollection, Boolean>();
        tempVar.setKey(CounterDataCollection2);
        tempVar.setValue(true);
        this._statsIndex.AddToIndex(tempVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<IntervalCounterDataCollection> GetStatsData(RefObject<Long> startTime) {
        SlidingIndex<MutableKeyValuePair<IntervalCounterDataCollection, Boolean>> slidingIndex = this._statsIndex;
        synchronized (slidingIndex) {
            Enumerator<MutableKeyValuePair<IntervalCounterDataCollection, Boolean>> en = this._statsIndex.GetCurrentData(startTime, false);
            ArrayList<IntervalCounterDataCollection> list = new ArrayList<IntervalCounterDataCollection>();
            while (en.MoveNext()) {
                MutableKeyValuePair<IntervalCounterDataCollection, Boolean> current = en.getCurrent();
                if (!current.getValue().booleanValue()) continue;
                IntervalCounterDataCollection present = current.getKey();
                list.add(present);
                current.setValue(false);
            }
            return list;
        }
    }

    public final void AddToLogIndex(Object obj) {
        this._logIndex.AddToIndex(obj);
    }

    public final void AddToAPILogIndex(Object obj) {
    }

    @Override
    public void close() throws Exception {
        if (this._statsIndex != null) {
            this._statsIndex.close();
        }
        if (this._logIndex != null) {
            this._logIndex.close();
        }
    }
}

