/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import com.alachisoft.ncache.common.monitoring.CounterDataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CounterIDMap {
    private ArrayList<CounterMetadata> counterMetadata = new ArrayList();
    private ArrayList<String> counterNames = new ArrayList();
    private HashMap<Short, String> counterIDMap = new HashMap();
    private ArrayList<Short> privateCounterIds;
    private String privateVersion;
    private String privateCategory;

    public final ArrayList<Short> getCounterIds() {
        return this.privateCounterIds;
    }

    public final void setCounterIds(ArrayList<Short> value) {
        this.privateCounterIds = value;
    }

    public final String getVersion() {
        return this.privateVersion;
    }

    public final void setVersion(String value) {
        this.privateVersion = value;
    }

    public final String getCategory() {
        return this.privateCategory;
    }

    public final void setCategory(String value) {
        this.privateCategory = value;
    }

    public final void assignAndAddCounters(ArrayList<CounterMetadata> counters) {
        int counterId = 0;
        ArrayList<Short> ids = new ArrayList<Short>();
        for (CounterMetadata counterMeta : counters) {
            if (this.counterNames.contains(counterMeta.getName())) continue;
            this.counterNames.add(counterMeta.getName());
        }
        for (String name : this.counterNames) {
            if (!this.counterIDMap.containsKey((short)counterId)) {
                this.counterIDMap.put((short)counterId, name);
            }
            if (!ids.contains((short)counterId)) {
                ids.add((short)counterId);
            }
            ++counterId;
        }
        this.setCounterIds(ids);
    }

    public final short getCounterID(String counter) {
        if (this.counterIDMap != null && this.counterIDMap.values().contains(counter)) {
            for (Map.Entry<Short, String> entry : this.counterIDMap.entrySet()) {
                if (!counter.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return -10;
    }

    public final String getCounterName(short id) {
        String name = "";
        if (this.counterIDMap != null && (name = this.counterIDMap.get(id)) != null) {
            return name;
        }
        return name;
    }

    public final Map<String, Short> convertToNameMap(CounterDataCollection collection) {
        HashMap<String, Short> nameMap = new HashMap<String, Short>();
        if (this.counterIDMap != null) {
            for (Map.Entry<Short, String> val : this.counterIDMap.entrySet()) {
                nameMap.put(val.getValue(), val.getKey());
            }
        }
        return nameMap;
    }

    public final void Clear() {
        this.counterNames.clear();
        this.counterIDMap.clear();
        this.getCounterIds().clear();
    }
}

