/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.ClientMonitorMBean;
import com.alachisoft.ncache.common.caching.statistics.monitoring.Monitor;
import com.alachisoft.ncache.common.caching.statistics.operations.ClientOperations;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import java.util.EnumMap;
import org.weakref.jmx.Managed;

public class ClientMonitor
extends Monitor
implements ClientMonitorMBean {
    private static int jmxInstanceCounter = 0;
    private int clientNo;
    private EnumMap clientCounterStore = new EnumMap(ClientOperations.class);

    public ClientMonitor(String nodeName) {
        super(nodeName);
        this.setPort();
    }

    public ClientMonitor(String nodeName, ILogger logger) {
        super(nodeName, logger);
        this.setPort();
    }

    @Override
    public void setPort() {
    }

    @Override
    public void startJMX() {
        this.clientNo = ++jmxInstanceCounter;
        super.startJMX();
    }

    @Override
    public void stopJMX() {
        if (--jmxInstanceCounter == 0) {
            super.stopJMX();
        }
    }

    @Override
    public void registerCounter(Operations operation, PerformanceCounter perfCounter) throws Exception {
        if (operation == null || perfCounter == null) {
            throw new Exception("Opertation or perfcounter cannot be null");
        }
        this.getCounterStore().put((Enum)((Object)operation), perfCounter);
    }

    @Override
    public void unRegisterCounter(Operations type) {
    }

    @Override
    public EnumMap getCounterStore() {
        return this.clientCounterStore;
    }

    @Override
    public double getCounter(Operations operation) {
        return ((PerformanceCounter)this.getCounterStore().get(operation)).getValue();
    }

    @Override
    public String getExportString() {
        return this.getExportStringPrefix() + "client." + this.getNodeName() + this.clientNo;
    }

    @Override
    public String getNodeName() {
        return super.getNodeName();
    }

    @Override
    @Managed(description="Average size of the item added to/fetched from the cache by the client. Average size is calculated before compression/after decompression is applied.", name="Average Item Size")
    public double getAverageItemSize() {
        return this.getCounter(ClientOperations.AvgItemSize);
    }

    @Override
    @Managed(description="Percentage of CPU utilized by the client for performing operations.  ", name="Client CPU Usage")
    public double getCpuUsage() {
        return this.getCounter(ClientOperations.CpuUsage);
    }

    @Override
    @Managed(description="Number of Add operations per second.", name="Additions/sec")
    public double getAddsPerSec() {
        return this.getCounter(ClientOperations.AddsPerSec);
    }

    @Override
    @Managed(description="Number of Get operations per second.", name="Fetches/sec")
    public double getGetsPerSec() {
        return this.getCounter(ClientOperations.GetPerSec);
    }

    @Override
    @Managed(description="Number of Insert operations per second.", name="Updates/sec")
    public double getInsertsPerSec() {
        return this.getCounter(ClientOperations.UpdPerSec);
    }

    @Override
    @Managed(description="Number of Remove operations per second.", name="Deletes/sec")
    public double getDelsPerSec() {
        return this.getCounter(ClientOperations.DelPerSec);
    }

    @Override
    @Managed(description="Total number of rquests from all clients on a single machine waiting for response from cache server", name="Request queue size")
    public double getRequestQueueSize() {
        return this.getCounter(ClientOperations.RequestQueueSize);
    }

    @Override
    @Managed(description="Number of Read operations per second", name="Read Operations/sec")
    public double getReadOpsPerSec() {
        return this.getCounter(ClientOperations.ReadOperationsPerSec);
    }

    @Override
    @Managed(description="Number of Write operations per second", name="Write Operations/sec")
    public double getWriteOpsPerSec() {
        return this.getCounter(ClientOperations.WriteOperationsPerSec);
    }

    @Override
    @Managed(description="Amount of network used by client to send/recived operations in percentage", name="Client Network Usage")
    public double getNetworkUsage() {
        return this.getCounter(ClientOperations.NetworkUsage);
    }

    @Override
    @Managed(description="The memory (in Magabyte) being used by the runing client. ", name="Client Memory Usage")
    public double getMemoryUsage() {
        return this.getCounter(ClientOperations.MemoryUsage);
    }

    @Override
    @Managed(description="Number of requests received (meaning cache commands like add, get, insert, remove etc.) by this client", name="Requests/sec")
    public double getRequestPerSec() {
        return this.getCounter(ClientOperations.RequestsPerSec);
    }

    @Override
    @Managed(description="Average time, in microseconds, taken to serialize/deserialize one object.", name="Average \u00c2\u00b5s/serialization")
    public double getMsecPerSerialization() {
        return this.getCounter(ClientOperations.MsecPerSerializationAvg);
    }

    @Override
    @Managed(description="Average time, in microseconds, taken to compress/decompress one object.", name="Average \u00c2\u00b5s/compression")
    public double getMsecPerCompression() {
        return this.getCounter(ClientOperations.MsecPerCompressionAvg);
    }

    @Override
    @Managed(description="Rate of compression/decompression i.e. how many items are compressed/decompression during one second interval.", name="Compressions/sec")
    public double getCompressionsPerSec() {
        return this.getCounter(ClientOperations.CompressionPerSec);
    }

    @Override
    @Managed(description="Average size of the item after compression/before decompression added to/fetched from the cache.", name="Average Compressed Item Size")
    public double getAverageCompressedItemSize() {
        return this.getCounter(ClientOperations.AvgCompressedItemSize);
    }

    @Override
    @Managed(description="Average per milli-second time of Event operations.", name="Average \u00c2\u00b5s/Event")
    public double getMsecPerEvent() {
        return this.getCounter(ClientOperations.AvgEventPerSec);
    }

    @Override
    @Managed(description="Counter for events processed per second.", name="Event Processed/Sec")
    public double getEventProcessedPerSec() {
        return this.getCounter(ClientOperations.EventProcessedPerSec);
    }

    @Override
    @Managed(description="Counter for events Triggered/Received per second.", name="Event Triggered/Sec")
    public double getEventTriggeredPerSec() {
        return this.getCounter(ClientOperations.EventTriggeredPerSec);
    }
}

