/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CacheServerMBean;
import com.alachisoft.ncache.common.caching.statistics.monitoring.ServerMonitor;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import com.alachisoft.ncache.common.caching.statistics.operations.ServerOperations;
import java.util.EnumMap;
import org.weakref.jmx.Managed;

public class CacheServerMonitor
extends ServerMonitor
implements CacheServerMBean {
    public CacheServerMonitor(String nodeName) {
        super(nodeName);
    }

    public CacheServerMonitor(String nodeName, ILogger logger) {
        super(nodeName, logger);
    }

    @Override
    public EnumMap getCounterStore() {
        return CacheServerMonitor.getServerCounterStore();
    }

    @Override
    public double getCounter(Operations operation) {
        return 0.0;
    }

    @Override
    public void registerCounter(Operations operation, PerformanceCounter perfCounter) throws Exception {
    }

    @Override
    public void unRegisterCounter(Operations type) {
    }

    @Override
    public String getExportString() {
        return this.getExportStringPrefix() + "server";
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    @Managed(description="Number of bytes sent per second to other nodes of the cluster.", name="Bytes sent/sec")
    public double getByteSentPerSec() {
        return this.getCounter(ServerOperations.byteSentPerSec);
    }

    @Override
    @Managed(description="Number of bytes received per second from other nodes of the cluster.", name="Bytes received/sec")
    public double getByteReceivePerSec() {
        return this.getCounter(ServerOperations.bytereceivePerSec);
    }

    @Override
    @Managed(description="Number of items in event queue.", name="Event Queue Count")
    public double getEventQueueCount() {
        return this.getCounter(ServerOperations.eventQueueCount);
    }

    @Override
    @Managed(description="Number of General Notification Events in Queue.", name="General Notifications Queue Size")
    public double getGeneralNotificationQueueSize() {
        return this.getCounter(ServerOperations.generalNotificationQueueSize);
    }

    @Override
    @Managed(description="Size of response queue specified in bytes.", name="Response Queue Size")
    public double getResponseQueueSize() {
        return this.getCounter(ServerOperations.responseQueueSize);
    }

    @Override
    @Managed(description="Number of items in response queue.", name="Response Queue Count")
    public double getResponseQueueCount() {
        return this.getCounter(ServerOperations.responseQueueSize);
    }
}

