/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters;

import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemCounter;

public class VMCpuUsage
extends SystemCounter {
    long nanoBefore;
    long cpuBefore;
    long cpuAfter;
    long nanoAfter;

    public VMCpuUsage(String name, String instance) {
        super(name, instance);
        if (VMCpuUsage.getSunOSMXBean() != null && VMCpuUsage.getJavaOSMXBean() != null) {
            this.nanoBefore = System.nanoTime();
            this.cpuBefore = VMCpuUsage.getSunOSMXBean().getProcessCpuTime();
        }
    }

    @Override
    protected void calculate(double percent) {
        if (VMCpuUsage.getSunOSMXBean() != null && VMCpuUsage.getJavaOSMXBean() != null) {
            this.cpuAfter = VMCpuUsage.getSunOSMXBean().getProcessCpuTime();
            this.nanoAfter = System.nanoTime();
            percent = this.nanoAfter > this.nanoBefore ? (double)(this.cpuAfter - this.cpuBefore) * 100.0 / (double)(this.nanoAfter - this.nanoBefore) : 0.0;
            this.setValue(percent / (double)VMCpuUsage.getJavaOSMXBean().getAvailableProcessors());
            this.cpuBefore = VMCpuUsage.getSunOSMXBean().getProcessCpuTime();
            this.nanoBefore = System.nanoTime();
        }
    }
}

