/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.customcounters;

import com.alachisoft.ncache.common.caching.statistics.customcounters.InstantaneousCounter;

public class AverageCounter
extends InstantaneousCounter {
    private double _sum = 0.0;
    private double _totalCount = 0.0;

    public AverageCounter(String name, String instance) {
        super(name, instance);
    }

    public AverageCounter(String category, String name, String instance) {
        super(category, name, instance);
    }

    @Override
    protected void calculate(double value) {
        this._sum += value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBy(double value, double count) {
        AverageCounter averageCounter = this;
        synchronized (averageCounter) {
            super.incrementBy(value);
            this._totalCount += count;
            this._value = this._totalCount != 0.0 ? this._sum / this._totalCount : 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBase(long count) {
        AverageCounter averageCounter = this;
        synchronized (averageCounter) {
            this._totalCount += (double)count;
        }
    }

    @Override
    public void incrementBy(double value) {
        this.incrementBy(value, 1.0);
    }

    @Override
    protected void flipChanged() {
        this._sum = 0.0;
        this._totalCount = 0.0;
    }

    @Override
    public void decrement() {
    }

    @Override
    public void decrementBy(double value) {
    }

    @Override
    public void setValue(double _value) {
        this._lastValue = this._value;
        this._value = _value;
    }

    @Override
    public double getValue() {
        return this._value;
    }

    public double getTotalCount() {
        return this._totalCount;
    }

    public double getSum() {
        return this._sum;
    }
}

