/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.mapreduce;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class TaskEnumeratorPointer
implements InternalCompactSerializable {
    private String taskID;
    private Short callbackID;
    private String clientId;
    private Address clientAddress;
    private Address clusterAddress;

    public TaskEnumeratorPointer() {
    }

    public TaskEnumeratorPointer(String clientID, String taskID, short callbackID) {
        this.clientId = clientID;
        this.taskID = taskID;
        this.callbackID = callbackID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskEnumeratorPointer) {
            TaskEnumeratorPointer other = (TaskEnumeratorPointer)(obj instanceof TaskEnumeratorPointer ? obj : null);
            if (!other.getClientId().equals(this.clientId)) {
                return false;
            }
            return other.getCallbackID().equals((short)this.callbackID);
        }
        return false;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public Short getCallbackID() {
        return this.callbackID;
    }

    public int hashCode() {
        return this.taskID.hashCode() + this.callbackID.hashCode() + this.getClientId().hashCode();
    }

    public Address getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(Address clientAddress) {
        this.clientAddress = clientAddress;
    }

    public Address getClusterAddress() {
        return this.clusterAddress;
    }

    public void setClusterAddress(Address clusterAddress) {
        this.clusterAddress = clusterAddress;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.setClientAddress(Common.as(reader.ReadObject(), Address.class));
        this.setClusterAddress(Common.as(reader.ReadObject(), Address.class));
        this.clientId = Common.as(reader.ReadObject(), String.class);
        this.taskID = Common.as(reader.ReadObject(), String.class);
        this.callbackID = reader.ReadInt16();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this.getClientAddress());
        writer.WriteObject((Object)this.getClusterAddress());
        writer.WriteObject((Object)this.clientId);
        writer.WriteObject((Object)this.taskID);
        writer.Write(this.callbackID.shortValue());
    }
}

