/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Util;

import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.runtime.dependencies.AggregateCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.dependencies.CmdParamsType;
import com.alachisoft.ncache.runtime.dependencies.CustomDependency;
import com.alachisoft.ncache.runtime.dependencies.DBCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.DBDependencyFactory;
import com.alachisoft.ncache.runtime.dependencies.DBDependencyType;
import com.alachisoft.ncache.runtime.dependencies.ExtensibleDependency;
import com.alachisoft.ncache.runtime.dependencies.FileDependency;
import com.alachisoft.ncache.runtime.dependencies.KeyDependency;
import com.alachisoft.ncache.runtime.dependencies.KeyDependencyType;
import com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParams;
import com.alachisoft.ncache.runtime.dependencies.OracleCmdParamsType;
import com.alachisoft.ncache.runtime.dependencies.OracleCommandType;
import com.alachisoft.ncache.runtime.dependencies.OracleParameterDirection;
import com.alachisoft.ncache.runtime.dependencies.SqlCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.SqlCmdParams;
import com.alachisoft.ncache.runtime.dependencies.SqlCmpOptions;
import com.alachisoft.ncache.runtime.dependencies.SqlCommandType;
import com.alachisoft.ncache.runtime.dependencies.SqlParamDirection;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import microsoft.sql.DateTimeOffset;
import tangible.RefObject;

public class DependencyHelper {
    public static CacheDependency getCacheDependency(DependencyProtocol.Dependency dependency) throws IllegalArgumentException, OperationFailedException {
        HashMap<String, Object> parameters;
        int i;
        Object cacheDependency = null;
        RefObject<Object> temp_CacheDependency = new RefObject<Object>(cacheDependency);
        if (dependency == null) {
            return null;
        }
        if (dependency.getKeyDepList().size() > 0) {
            for (i = 0; i < dependency.getKeyDepList().size(); ++i) {
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)new KeyDependency(dependency.getKeyDepList().get(i).getKeysList(), new NCDateTime(dependency.getKeyDepList().get(i).getStartAfter()).getDate(), KeyDependencyType.forValue((int)dependency.getKeyDepList().get(i).getKeyDependencyType())));
            }
        }
        if (dependency.getFileDepList().size() > 0) {
            for (i = 0; i < dependency.getFileDepList().size(); ++i) {
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)new FileDependency(dependency.getFileDepList().get(i).getFilePathsList(), new NCDateTime(dependency.getFileDepList().get(i).getStartAfter()).getDate()));
            }
        }
        if (dependency.getOleDbDepList().size() > 0) {
            for (i = 0; i < dependency.getOleDbDepList().size(); ++i) {
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)DBDependencyFactory.createOleDbCacheDependency((String)dependency.getOleDbDepList().get(i).getConnectionString(), (String)dependency.getOleDbDepList().get(i).getDbCacheKey()));
            }
        }
        if (dependency.getSql7DepList().size() > 0) {
            for (i = 0; i < dependency.getSql7DepList().size(); ++i) {
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)DBDependencyFactory.createSqlCacheDependency((String)dependency.getSql7DepList().get(i).getConnectionString(), (String)dependency.getSql7DepList().get(i).getDbCacheKey()));
            }
        }
        if (dependency.getOracleDepCount() > 0) {
            for (i = 0; i < dependency.getOracleDepCount(); ++i) {
                parameters = new HashMap<String, Object>();
                for (int pc = 0; pc < dependency.getOracleDep(i).getParamCount(); ++pc) {
                    OracleCmdParams commandParam = new OracleCmdParams();
                    commandParam.setDirection(OracleParameterDirection.getOracleParameterDirection((int)dependency.getOracleDep(i).getParam(pc).getCmdParam().getDirection()));
                    commandParam.setType(OracleCmdParamsType.getOracleCmdParamsType((int)dependency.getOracleDep(i).getParam(pc).getCmdParam().getDbType()));
                    commandParam.setValue((Object)dependency.getOracleDep(i).getParam(pc).getCmdParam().getValue());
                    parameters.put(dependency.getOracleDep(i).getParam(pc).getKey(), commandParam);
                }
                OracleCacheDependency oraDep = new OracleCacheDependency(dependency.getOracleDep(i).getConnectionString(), dependency.getOracleDep(i).getQuery(), OracleCommandType.forValue((int)dependency.getOracleDep(i).getCommandType()), parameters);
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)oraDep);
            }
        }
        if (dependency.getYukonDepCount() > 0) {
            for (i = 0; i < dependency.getYukonDepCount(); ++i) {
                parameters = new HashMap();
                for (int pc = 0; pc < dependency.getYukonDep(i).getParamCount(); ++pc) {
                    DependencyProtocol.YukonCommandParam yukonParam = dependency.getYukonDep(i).getParam(pc).getCmdParam();
                    SqlCmdParams commandParam = new SqlCmdParams();
                    commandParam.setCompareInfo(SqlCmpOptions.getSqlCmpOptions((int)yukonParam.getCmpOptions()));
                    commandParam.setSqlParameterDirection(SqlParamDirection.forValue((int)yukonParam.getDirection()));
                    commandParam.setIsNullable(yukonParam.getIsNullable());
                    commandParam.setLocaleId(yukonParam.getLocaleId());
                    commandParam.setoffset(yukonParam.getOffset());
                    commandParam.setprecision((byte)yukonParam.getPrecision());
                    commandParam.setScale((byte)yukonParam.getScale());
                    commandParam.setSize(yukonParam.getSize());
                    commandParam.setSourceColumn(yukonParam.getSourceColumn());
                    commandParam.setSourceColumnNullMapping(yukonParam.getSourceColumnNull());
                    commandParam.setSqlValue((Object)yukonParam.getSqlValue());
                    commandParam.setCmdParamsType(CmdParamsType.forValue((int)yukonParam.getTypeId()));
                    commandParam.setTypeName(yukonParam.getTypeName());
                    commandParam.setUdtTypeName(yukonParam.getUdtTypeName());
                    if (!yukonParam.getNullValueProvided()) {
                        String val = yukonParam.getValue();
                        if (commandParam.getCmdParamsType() == CmdParamsType.Binary || commandParam.getCmdParamsType() == CmdParamsType.VarBinary || commandParam.getCmdParamsType() == CmdParamsType.Timestamp) {
                            try {
                                commandParam.setValue((Object)val.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else if (commandParam.getCmdParamsType() == CmdParamsType.DateTime || commandParam.getCmdParamsType() == CmdParamsType.DateTime2 || commandParam.getCmdParamsType() == CmdParamsType.SmallDateTime) {
                            Timestamp timeStamp = new Timestamp(Long.valueOf(val));
                            commandParam.setValue((Object)timeStamp);
                        } else if (commandParam.getCmdParamsType() == CmdParamsType.Date) {
                            Date date = new Date(Long.valueOf(val));
                            commandParam.setValue((Object)date);
                        } else if (commandParam.getCmdParamsType() == CmdParamsType.Time) {
                            Time time = new Time(Long.valueOf(val));
                            commandParam.setValue((Object)time);
                        } else if (commandParam.getCmdParamsType() == CmdParamsType.DateTimeOffset) {
                            String[] dateOffset = val.split(",");
                            DateTimeOffset offset = DateTimeOffset.valueOf((Timestamp)Timestamp.valueOf(dateOffset[0]), (int)Integer.valueOf(dateOffset[1]));
                            commandParam.setValue((Object)offset);
                        } else {
                            commandParam.setValue((Object)val);
                        }
                    }
                    parameters.put(dependency.getYukonDep(i).getParam(i).getKey(), commandParam);
                }
                SqlCacheDependency yukonDep = new SqlCacheDependency(dependency.getYukonDep(i).getConnectionString(), dependency.getYukonDep(i).getQuery(), SqlCommandType.getSqlCommandType((int)dependency.getYukonDep(i).getCommandType()), parameters);
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)yukonDep);
            }
        }
        if (dependency.getCustomDepCount() > 0) {
            for (i = 0; i < dependency.getCustomDepCount(); ++i) {
                HashMap<String, String> parameter = new HashMap<String, String>();
                DependencyProtocol.CustomDependency customDependency = dependency.getCustomDep(i);
                for (int pc = 0; pc < customDependency.getParametersCount(); ++pc) {
                    parameter.put(customDependency.getParameters(pc).getName(), customDependency.getParameters(pc).getValue());
                }
                DependencyHelper.addToDependency(temp_CacheDependency, (CacheDependency)new CustomDependency(dependency.getCustomDep(i).getProviderName(), parameter));
            }
        }
        return (CacheDependency)temp_CacheDependency.argvalue;
    }

    public static DependencyProtocol.Dependency getDependencyProtocol(CacheDependency cacheDependency) throws Exception {
        if (cacheDependency == null) {
            return null;
        }
        DependencyProtocol.Dependency.Builder protoDep = DependencyProtocol.Dependency.newBuilder();
        return DependencyHelper.getProtoBufDependency(cacheDependency, protoDep).build();
    }

    public static DependencyProtocol.Dependency.Builder getProtoBufDependency(CacheDependency cacheDependency, DependencyProtocol.Dependency.Builder dependency) throws OperationFailedException, UnsupportedEncodingException, IOException, IllegalArgumentException {
        if (cacheDependency instanceof FileDependency) {
            FileDependency fileDependency = (FileDependency)cacheDependency;
            dependency.addFileDep(DependencyProtocol.FileDependency.newBuilder().addAllFilePaths(fileDependency.getFileNames()).setStartAfter(fileDependency.getStartAfterTicks()).build());
            return dependency;
        }
        if (cacheDependency instanceof KeyDependency) {
            KeyDependency keydependency = (KeyDependency)cacheDependency;
            dependency.addKeyDep(DependencyProtocol.KeyDependency.newBuilder().addAllKeys(keydependency.getCacheKeys()).setStartAfter(keydependency.getStartAfterTicks()).setKeyDependencyType(keydependency.getKeyDependencyType().getValue()).build());
            return dependency;
        }
        if (cacheDependency instanceof DBCacheDependency) {
            DBCacheDependency dep = (DBCacheDependency)cacheDependency;
            if (dep.getDBDependencyType() == DBDependencyType.SqlCacheDependency) {
                dependency.addSql7Dep(DependencyProtocol.Sql7Dependency.newBuilder().setConnectionString(dep.getConnectionString()).setDbCacheKey(dep.getPrimaryKey()).build());
            } else if (dep.getDBDependencyType() == DBDependencyType.OleDbCacheDependency) {
                dependency.addOleDbDep(DependencyProtocol.OleDbDependency.newBuilder().setConnectionString(dep.getConnectionString()).setDbCacheKey(dep.getPrimaryKey()).build());
            }
            return dependency;
        }
        if (cacheDependency instanceof SqlCacheDependency) {
            SqlCacheDependency sqlDependency = (SqlCacheDependency)cacheDependency;
            DependencyProtocol.YukonDependency.Builder builder = DependencyProtocol.YukonDependency.newBuilder().setCommandType(sqlDependency.getCommandType().getValue()).setConnectionString(sqlDependency.getConnectionString()).setQuery(sqlDependency.getCommandText());
            if (sqlDependency.getCommandParams() != null && sqlDependency.getCommandParams() != null && sqlDependency.getCommandParams().size() > 0) {
                Iterator iterator = sqlDependency.getCommandParams().keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    SqlCmdParams cmdParam = (SqlCmdParams)sqlDependency.getCommandParams().get(key);
                    DependencyProtocol.YukonCommandParam.Builder paramBuilder = DependencyProtocol.YukonCommandParam.newBuilder();
                    paramBuilder.setDbType(cmdParam.getCmdParamsType().getValue());
                    paramBuilder.setDirection(cmdParam.getSqlParameterDirection().getValue()).setIsNullable(cmdParam.getIsNullable()).setLocaleId(cmdParam.getLocaleId()).setOffset(cmdParam.getoffset()).setPrecision(cmdParam.getPrecision()).setScale(cmdParam.getScale()).setSize(cmdParam.getSize()).setSourceColumn(cmdParam.getSourceColumn() != null ? cmdParam.getSourceColumn().toString() : "").setSourceColumnNull(cmdParam.getSourceColumnNullMapping()).setSqlValue(cmdParam.getSqlValue() != null ? cmdParam.getSqlValue().toString() : "").setVersion(cmdParam.getSourceVersion().getValue()).setTypeName(cmdParam.getTypeName() != null ? cmdParam.getTypeName().toString() : "").setTypeId(cmdParam.getCmdParamsType().getValue()).setUdtTypeName(cmdParam.getUdtTypeName() != null ? cmdParam.getUdtTypeName() : "").setNullValueProvided(cmdParam.getValue() == null);
                    if (!paramBuilder.getNullValueProvided()) {
                        Object val;
                        if (cmdParam.getCmdParamsType() == CmdParamsType.Binary || cmdParam.getCmdParamsType() == CmdParamsType.VarBinary || cmdParam.getCmdParamsType() == CmdParamsType.Timestamp) {
                            val = null;
                            try {
                                val = (byte[])cmdParam.getValue();
                                paramBuilder.setValue(new String((byte[])val, "UTF-8"));
                            }
                            catch (ClassCastException ex) {
                                throw new OperationFailedException("Expected byte[] for parameter type '" + cmdParam.getCmdParamsType() + "'");
                            }
                        } else if (cmdParam.getCmdParamsType() == CmdParamsType.DateTime || cmdParam.getCmdParamsType() == CmdParamsType.DateTime2 || cmdParam.getCmdParamsType() == CmdParamsType.SmallDateTime) {
                            try {
                                val = (Timestamp)cmdParam.getValue();
                                paramBuilder.setValue(Long.toString(HelperFxn.getTicks((java.util.Date)val)));
                            }
                            catch (ClassCastException ex) {
                                throw new OperationFailedException("Expected 'java.sql.Timestamp' for parameter type '" + cmdParam.getCmdParamsType() + "'");
                            }
                        } else if (cmdParam.getCmdParamsType() == CmdParamsType.Date) {
                            try {
                                val = (Date)cmdParam.getValue();
                                paramBuilder.setValue(Long.toString(HelperFxn.getTicks((java.util.Date)val)));
                            }
                            catch (ClassCastException ex) {
                                throw new OperationFailedException("Expected 'java.sql.Date' for parameter type '" + cmdParam.getCmdParamsType() + "'");
                            }
                        } else if (cmdParam.getCmdParamsType() == CmdParamsType.Time) {
                            try {
                                val = (Time)cmdParam.getValue();
                                paramBuilder.setValue(Long.toString(HelperFxn.getTicks((java.util.Date)val)));
                            }
                            catch (ClassCastException ex) {
                                throw new OperationFailedException("Expected 'java.sql.Time' for parameter type '" + cmdParam.getCmdParamsType() + "'");
                            }
                        } else if (cmdParam.getCmdParamsType() == CmdParamsType.DateTimeOffset) {
                            try {
                                val = (DateTimeOffset)cmdParam.getValue();
                                paramBuilder.setValue(HelperFxn.getTicks((java.util.Date)val.getTimestamp()) + "," + val.getMinutesOffset());
                            }
                            catch (ClassCastException ex) {
                                throw new OperationFailedException("Expected 'microsoft.sql.DateTimeOffset' for parameter type '" + cmdParam.getCmdParamsType() + "'");
                            }
                        } else {
                            paramBuilder.setValue(cmdParam.getValue().toString());
                        }
                    }
                    DependencyProtocol.YukonParam param = DependencyProtocol.YukonParam.newBuilder().setKey(key).setCmdParam(paramBuilder.build()).build();
                    builder = builder.addParam(param);
                }
            }
            dependency.addYukonDep(builder.build());
            return dependency;
        }
        if (cacheDependency instanceof OracleCacheDependency) {
            OracleCacheDependency oracleDependency = (OracleCacheDependency)cacheDependency;
            if (oracleDependency.getConnectionString() == null || oracleDependency.getConnectionString().isEmpty()) {
                throw new IllegalArgumentException("Connection string cannot be null or empty");
            }
            if (oracleDependency.getCommandText() == null || oracleDependency.getCommandText().isEmpty()) {
                throw new IllegalArgumentException("Command Text cannot be null or empty");
            }
            DependencyProtocol.OracleDependency.Builder oraclebuilder = DependencyProtocol.OracleDependency.newBuilder().setCommandType(oracleDependency.getCommandType() != null ? oracleDependency.getCommandType().getValue() : 1).setConnectionString(oracleDependency.getConnectionString()).setQuery(oracleDependency.getCommandText());
            if (oracleDependency.getCommandParams() != null) {
                Set keyEnumeration = oracleDependency.getCommandParams().entrySet();
                for (Map.Entry entry : keyEnumeration) {
                    String key = (String)entry.getKey();
                    OracleCmdParams cmdParam = (OracleCmdParams)oracleDependency.getCommandParams().get(key);
                    DependencyProtocol.OracleParam param = DependencyProtocol.OracleParam.newBuilder().setKey(key).setCmdParam(DependencyProtocol.OracleCommandParam.newBuilder().setDbType(cmdParam.getType().getValue()).setDirection(cmdParam.getDirection().getValue()).setValue(cmdParam.getValue() != null ? cmdParam.getValue().toString() : "").build()).build();
                    oraclebuilder = oraclebuilder.addParam(param);
                }
            }
            dependency.addOracleDep(oraclebuilder.build());
            return dependency;
        }
        if (cacheDependency instanceof ExtensibleDependency) {
            ExtensibleDependency extDependency = (ExtensibleDependency)cacheDependency;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(stream);
            out.writeObject(extDependency);
            stream.toByteArray();
            DependencyProtocol.ExtensibleDependency.Builder extensibleBuilder = DependencyProtocol.ExtensibleDependency.newBuilder().setData(ByteString.copyFrom(stream.toByteArray()));
            dependency.addXtDep(extensibleBuilder.build());
            return null;
        }
        if (cacheDependency instanceof CustomDependency) {
            CustomDependency customDependency = (CustomDependency)cacheDependency;
            DependencyProtocol.CustomDependency.Builder customDependencyBuilder = DependencyProtocol.CustomDependency.newBuilder().setProviderName(customDependency.getProviderName());
            customDependencyBuilder.setProviderName(customDependency.getProviderName());
            for (Map.Entry param : customDependency.getParameters().entrySet()) {
                if (param.getKey() == null || param.getValue() == null) {
                    throw new IllegalArgumentException("custom dependencies keys and values must not be null");
                }
                DependencyProtocol.Dictionary.Builder dictionary = DependencyProtocol.Dictionary.newBuilder();
                dictionary.setName(param.getKey().toString());
                dictionary.setValue(param.getValue().toString());
                customDependencyBuilder.addParameters(dictionary);
            }
            dependency.addCustomDep(customDependencyBuilder);
            return dependency;
        }
        if (cacheDependency instanceof AggregateCacheDependency) {
            AggregateCacheDependency aggregateDependency = (AggregateCacheDependency)cacheDependency;
            for (CacheDependency dep : aggregateDependency.getDependencies()) {
                DependencyHelper.getProtoBufDependency(dep, dependency);
            }
        }
        return dependency;
    }

    private static void addToDependency(RefObject<CacheDependency> cacheDependency, CacheDependency newDependency) {
        if (cacheDependency.argvalue != null) {
            ((CacheDependency)cacheDependency.argvalue).getDependencies().add(newDependency);
        } else {
            cacheDependency.argvalue = new CacheDependency(newDependency);
        }
    }
}

