/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Streams;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import tangible.RefObject;

public class BufferedStream
extends OutputStream {
    private final int _DefaultBufferSize = 4096;
    private final int _bufferSize;
    private final int MaxShadowBufferSize = 81920;
    OutputStream _stream;
    private int _writePos;
    private byte[] _buffer;
    private int _readPos;
    private int _readLen;
    private AtomicInteger writeCount = new AtomicInteger(0);

    public BufferedStream(Socket primaryClient, boolean b, int bufferSize) {
        this._bufferSize = bufferSize;
        try {
            this._stream = primaryClient.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BufferedStream(Socket primaryClient, boolean b) {
        this._bufferSize = 4096;
        try {
            this._stream = primaryClient.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getWriteCount() {
        return this.writeCount.get();
    }

    private void EnsureNotClosed() throws IOException {
        if (this._stream == null) {
            throw new IOException("Stream is closed.");
        }
    }

    private void WriteToBuffer(byte[] array, RefObject<Integer> tempRefOffset, RefObject<Integer> tempRefCount) {
        int bytesToWrite = Math.min(this._bufferSize - this._writePos, (Integer)tempRefCount.argvalue);
        if (bytesToWrite <= 0) {
            return;
        }
        this.EnsureBufferAllocated();
        System.arraycopy(array, (Integer)tempRefOffset.argvalue, this._buffer, this._writePos, bytesToWrite);
        this._writePos += bytesToWrite;
        tempRefCount.setValue(tempRefCount.getValue() - bytesToWrite);
        tempRefOffset.setValue(tempRefOffset.getValue() + bytesToWrite);
    }

    private void EnsureBufferAllocated() {
        if (this._bufferSize > 0 && this._buffer == null) {
            this._buffer = new byte[this._bufferSize];
        }
    }

    @Override
    public void write(int b) throws IOException {
    }

    @Override
    public void write(byte[] array, int offset, int count) throws IOException {
        boolean useBuffer;
        if (array == null) {
            throw new NullPointerException("Buffer cannot be null. Parameter name: array");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Non-negative number required. Parameter name: offset");
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException("Non-negative number required. Parameter name: count");
        }
        if (array.length - offset < count) {
            throw new IllegalArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        this.EnsureNotClosed();
        int totalUserBytes = this._writePos + count;
        boolean bl = useBuffer = totalUserBytes + count < this._bufferSize + this._bufferSize;
        if (useBuffer) {
            RefObject<Integer> tempRefOffset = new RefObject<Integer>(offset);
            RefObject<Integer> tempRefCount = new RefObject<Integer>(count);
            this.WriteToBuffer(array, tempRefOffset, tempRefCount);
            count = (Integer)tempRefCount.argvalue;
            offset = (Integer)tempRefOffset.argvalue;
            if (this._writePos < this._bufferSize) {
                return;
            }
            this._stream.write(this._buffer, 0, this._writePos);
            this.writeCount.incrementAndGet();
            this._writePos = 0;
            RefObject<Integer> tempRefOffset2 = new RefObject<Integer>(offset);
            RefObject<Integer> tempRefCount2 = new RefObject<Integer>(count);
            this.WriteToBuffer(array, tempRefOffset2, tempRefCount2);
            count = tempRefCount2.getValue();
            offset = tempRefOffset2.getValue();
        } else {
            if (this._writePos > 0) {
                if (totalUserBytes <= this._bufferSize + this._bufferSize && totalUserBytes <= 81920) {
                    this.EnsureShadowBufferAllocated();
                    System.arraycopy(array, offset, this._buffer, this._writePos, count);
                    this._stream.write(this._buffer, 0, totalUserBytes);
                    this.writeCount.incrementAndGet();
                    this._writePos = 0;
                    return;
                }
                this._stream.write(this._buffer, 0, this._writePos);
                this.writeCount.incrementAndGet();
                this._writePos = 0;
            }
            this._stream.write(array, offset, count);
            this.writeCount.incrementAndGet();
        }
    }

    private void EnsureShadowBufferAllocated() {
        if (this._buffer.length != this._bufferSize || this._bufferSize >= 81920) {
            return;
        }
        byte[] shadowBuffer = new byte[Math.min(this._bufferSize + this._bufferSize, 81920)];
        System.arraycopy(this._buffer, 0, shadowBuffer, 0, this._writePos);
        this._buffer = shadowBuffer;
    }

    @Override
    public void flush() throws IOException {
        this.EnsureNotClosed();
        if (this._writePos > 0) {
            this.flushWrite();
            return;
        }
        if (this._readPos < this._readLen) {
            if (this._stream instanceof BufferedStream) {
                this._stream.flush();
                this.writeCount.incrementAndGet();
            }
            return;
        }
        if (this._stream instanceof BufferedStream) {
            this._stream.flush();
            this.writeCount.incrementAndGet();
        }
        this._readLen = 0;
        this._readPos = 0;
        this._writePos = 0;
    }

    private void flushWrite() throws IOException {
        this._stream.write(this._buffer, 0, this._writePos);
        this.writeCount.incrementAndGet();
        this._writePos = 0;
        this._stream.flush();
    }
}

