/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Stats;

import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.io.Serializable;
import java.util.Calendar;

public class TimeStats
implements Serializable {
    private long _runCount;
    private long _lastStart;
    private long _lastStop;
    private long _totalTime;
    private long _bestTime;
    private long _worstTime;
    private float _avgTime;
    private long _totalRunCount;
    private long _worstThreshHole = Long.MAX_VALUE;
    private long _worstOccurance;

    public TimeStats() {
        this.Reset();
    }

    public TimeStats(long worstThreshHoleValue) {
        this.Reset();
        this._worstThreshHole = worstThreshHoleValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRuns() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._runCount;
        }
    }

    public final long getWorstThreshHoldValue() {
        return this._worstThreshHole;
    }

    public final void setWorstThreshHoldValue(long value) {
        this._worstThreshHole = value;
    }

    public final long getTotalWorstCases() {
        return this._worstOccurance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTotal() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._totalTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCurrent() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._lastStop - this._lastStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getBest() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._bestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAvg() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._avgTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getWorst() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            return this._worstTime;
        }
    }

    public final void Reset() {
        this._runCount = 0L;
        this._worstOccurance = 0L;
        this._worstTime = 0L;
        this._bestTime = 0L;
        this._totalTime = 0L;
        this._avgTime = 0.0f;
    }

    public final void BeginSample() {
        this._lastStart = (new NCDateTime(Calendar.getInstance().getTimeInMillis()).getTicks() - 621355968000000000L) / 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void EndSample() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            this._lastStop = (new NCDateTime(Calendar.getInstance().getTimeInMillis()).getTicks() - 621355968000000000L) / 10000L;
            this.AddSampleTime(this.getCurrent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void EndSample(int runcount) {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            this._lastStop = (new NCDateTime(Calendar.getInstance().getTimeInMillis()).getTicks() - 621355968000000000L) / 10000L;
            this.AddSampleTime(this.getCurrent(), runcount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddSampleTime(long time) {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            ++this._runCount;
            ++this._totalRunCount;
            if (this._runCount == 1L) {
                this._bestTime = this._worstTime = time;
                this._totalTime = this._worstTime;
                this._avgTime = this._worstTime;
            } else {
                this._totalTime += time;
                if (time < this._bestTime) {
                    this._bestTime = time;
                }
                if (time > this._worstTime) {
                    this._worstTime = time;
                }
                if (time > this._worstThreshHole) {
                    ++this._worstOccurance;
                }
                this._avgTime = (float)this._totalTime / (float)this._runCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddSampleTime(long time, int runcount) {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            this._runCount += (long)runcount;
            this._totalRunCount += (long)runcount;
            if (this._runCount == 1L) {
                this._bestTime = this._worstTime = time;
                this._totalTime = this._worstTime;
                this._avgTime = this._worstTime;
            } else {
                this._totalTime += time;
                if (time < this._bestTime) {
                    this._bestTime = time;
                }
                if (time > this._worstTime) {
                    this._worstTime = time;
                }
                if (time > this._worstThreshHole) {
                    ++this._worstOccurance;
                }
                this._avgTime = (float)this._totalTime / (float)this._runCount;
            }
        }
    }

    public final long getTotalRunCount() {
        return this._totalRunCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TimeStats timeStats = this;
        synchronized (timeStats) {
            String retval = "[Runs: " + this._runCount + ", ";
            retval = retval + "Best(ms): " + this._bestTime + ", ";
            retval = retval + "Avg.(ms): " + this._avgTime + ", ";
            retval = retval + "Worst(ms): " + this._worstTime + ", ";
            retval = retval + "WorstThreshHole(ms): " + this._worstThreshHole + ", ";
            retval = retval + "Worst cases: " + this._worstOccurance + "]";
            return retval;
        }
    }
}

