/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Stats;

import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;

public class HPTimeStats
implements ICompactSerializable {
    private static double _frequency;
    private long _runCount;
    private long _lastStart;
    private long _lastStop;
    private double _totalTime;
    private double _bestTime;
    private double _worstTime;
    private double _avgTime;
    private long _totalRunCount;
    private float _avgCummulativeOperations;
    private double _worstThreshHole = Double.MAX_VALUE;
    private long _worstOccurance;

    public HPTimeStats() {
        this.Reset();
    }

    public HPTimeStats(double worstThreshHoleValue) {
        this.Reset();
        this._worstThreshHole = worstThreshHoleValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRuns() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._runCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRuns(long value) {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            this._runCount = value;
        }
    }

    public final double getWorstThreshHoldValue() {
        return this._worstThreshHole;
    }

    public final void setWorstThreshHoldValue(double value) {
        this._worstThreshHole = value;
    }

    public final long getTotalWorstCases() {
        return this._worstOccurance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getTotal() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._totalTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getCurrent() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._lastStop - this._lastStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getBest() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._bestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getAvg() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._avgTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAvgOperations() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._avgCummulativeOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getWorst() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            return this._worstTime;
        }
    }

    public final void Reset() {
        this._runCount = 0L;
        this._worstOccurance = 0L;
        this._bestTime = this._worstTime = (double)0L;
        this._totalTime = this._worstTime;
        this._avgTime = 0.0;
        this._avgCummulativeOperations = 0.0f;
    }

    public final void BeginSample() {
        this._lastStart = this._lastStart = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void EndSample() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            this._lastStop = this._lastStop = System.currentTimeMillis();
            this.AddSampleTime(this.getCurrent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void EndSample(int runcount) {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            this._lastStop = this._lastStop = System.currentTimeMillis();
            this.AddSampleTime(this.getCurrent(), runcount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddSampleTime(double time) {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            ++this._runCount;
            ++this._totalRunCount;
            if (this._runCount == 1L) {
                this._bestTime = this._worstTime = time;
                this._totalTime = this._worstTime;
                this._avgTime = this._worstTime;
            } else {
                this._totalTime += time;
                if (time < this._bestTime) {
                    this._bestTime = time;
                }
                if (time > this._worstTime) {
                    this._worstTime = time;
                }
                if (time > this._worstThreshHole) {
                    ++this._worstOccurance;
                }
                this._avgTime = this._totalTime / (double)this._runCount;
            }
            this._avgCummulativeOperations = this._totalTime < 1000.0 ? (float)this._runCount : (float)this._runCount * 1000.0f / (float)this._totalTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddSampleTime(double time, int runcount) {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            this._runCount += (long)runcount;
            this._totalRunCount += (long)runcount;
            if (this._runCount == 1L) {
                this._bestTime = this._worstTime = time;
                this._totalTime = this._worstTime;
                this._avgTime = this._worstTime;
            } else {
                this._totalTime += time;
                if (time < this._bestTime) {
                    this._bestTime = time;
                }
                if (time > this._worstTime) {
                    this._worstTime = time;
                }
                if (time > this._worstThreshHole) {
                    ++this._worstOccurance;
                }
                this._avgTime = (float)this._totalTime / (float)this._runCount;
            }
            this._avgCummulativeOperations = this._totalTime < 1000.0 ? (float)this._runCount : (float)this._runCount * 1000.0f / (float)this._totalTime;
        }
    }

    public final long getTotalRunCount() {
        return this._totalRunCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HPTimeStats hPTimeStats = this;
        synchronized (hPTimeStats) {
            String retval = "[Runs: " + this._runCount + ", ";
            retval = retval + "Best(ms): " + this._bestTime + ", ";
            retval = retval + "Avg.(ms): " + this._avgTime + ", ";
            retval = retval + "Worst(ms): " + this._worstTime + ", ";
            retval = retval + "WorstThreshHole(ms): " + this._worstThreshHole + ", ";
            retval = retval + "Worst cases: " + this._worstOccurance + "]";
            return retval;
        }
    }

    public final void deserialize(NCacheObjectInput reader) throws IOException {
        this._runCount = reader.readLong();
        this._avgTime = reader.readDouble();
        this._bestTime = reader.readDouble();
        this._lastStart = reader.readLong();
        this._lastStop = reader.readLong();
        this._worstThreshHole = reader.readDouble();
        this._worstTime = reader.readDouble();
        this._totalRunCount = reader.readLong();
        this._totalTime = reader.readDouble();
        this._worstOccurance = reader.readLong();
        this._avgCummulativeOperations = reader.readFloat();
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeLong(this._runCount);
        writer.writeDouble(this._avgTime);
        writer.writeDouble(this._bestTime);
        writer.writeLong(this._lastStart);
        writer.writeLong(this._lastStop);
        writer.writeDouble(this._worstThreshHole);
        writer.writeDouble(this._worstTime);
        writer.writeLong(this._totalRunCount);
        writer.writeDouble(this._totalTime);
        writer.writeLong(this._worstOccurance);
        writer.writeFloat(this._avgCummulativeOperations);
    }
}

