/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Net;

import Alachisoft.NCache.Common.Common;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.Enumeration;

public class Helper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreeTCPPort(InetAddress ipAddress) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    public static int getFreePort(InetAddress ipAddress) {
        int port = Helper.getFreeTCPPort(ipAddress);
        for (int retry = 20; retry > 0; --retry) {
            if (!Helper.isUDPPortFree(port, ipAddress)) continue;
            return port;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTCPPortFree(int port, InetAddress addr) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUDPPortFree(int port, InetAddress addr) {
        try (DatagramSocket ds = null;){
            ds = new DatagramSocket(port, addr);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public static boolean isPortFree(int port, InetAddress addr) {
        return Helper.isTCPPortFree(port, addr) && Helper.isUDPPortFree(port, addr);
    }

    public static InetAddress getFirstNonLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkdInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkdInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (address.isLoopbackAddress() || !Common.is(address, Inet4Address.class)) continue;
                    return address;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

