/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Net;

import Alachisoft.NCache.Common.Net.DnsCache;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Address
implements Cloneable,
Comparable,
ICompactSerializable,
Serializable {
    public static boolean resolve_dns = false;
    private InetAddress ip_addr;
    private int port;
    private byte[] additional_data;

    public Address() {
    }

    public Address(String i, int p) {
        try {
            this.ip_addr = Address.Resolve(i);
        }
        catch (UnknownHostException e) {
            try {
                this.ip_addr = Address.Resolve("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.port = p;
    }

    public Address(InetAddress i, int p) {
        this.ip_addr = i;
        this.port = p;
    }

    public Address(int port) {
        try {
            this.ip_addr = Address.Resolve(InetAddress.getLocalHost().getHostAddress());
            this.port = port;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static InetAddress Resolve(String addr) throws UnknownHostException {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            ip = DnsCache.ResolveName(addr);
        }
        return ip;
    }

    private static byte[] ParseIPAddress(String ipaddr) {
        byte[] address = null;
        String[] mcast = ipaddr.split("[.]", -1);
        if (mcast.length == 4) {
            address = new byte[4];
            try {
                address[0] = (byte)Integer.parseInt(mcast[0]);
                address[1] = (byte)Integer.parseInt(mcast[1]);
                address[2] = (byte)Integer.parseInt(mcast[2]);
                address[3] = (byte)Integer.parseInt(mcast[3]);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return address;
    }

    public static boolean isMulticastAddress(String ipaddr) {
        try {
            return Address.isMulticastAddress(Address.ParseIPAddress(ipaddr));
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isMulticastAddress(InetAddress ipAddr) {
        if (ipAddr != null) {
            String[] mcast = ipAddr.toString().split("[.]", -1);
            byte b1 = Byte.parseByte(mcast[0]);
            byte b2 = Byte.parseByte(mcast[1]);
            byte b3 = Byte.parseByte(mcast[2]);
            byte b4 = Byte.parseByte(mcast[3]);
            if (b1 < 224 || b1 > 240) {
                return false;
            }
            return b1 != 224 || b3 >= 1;
        }
        return false;
    }

    private static boolean isMulticastAddress(byte[] ipAddr) {
        if (ipAddr != null && ipAddr.length == 4) {
            if (ipAddr[0] < 224 || ipAddr[0] > 240) {
                return false;
            }
            return ipAddr[0] != 224 || ipAddr[2] >= 1;
        }
        return false;
    }

    public static Address Parse(String address) throws UnknownHostException {
        String[] hostPort = address.split("[:]", -1);
        return new Address(hostPort[0], Integer.parseInt(hostPort[1]));
    }

    public final InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean getMulticastAddress() {
        return this.ip_addr != null ? Address.isMulticastAddress(this.ip_addr) : false;
    }

    public final byte[] getAdditionalData() {
        return this.additional_data;
    }

    public final void setAdditionalData(byte[] value) {
        this.additional_data = value;
    }

    public final int compare(Address other) {
        return this.compareTo(other);
    }

    public final int compareTo(Object o) {
        int rc;
        int h1 = 0;
        int h2 = 0;
        if (o == null) {
            return 1;
        }
        Address other = (Address)(o instanceof Address ? o : null);
        if (other == null) {
            return 1;
        }
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        h1 = this.ip_addr.hashCode();
        if (other.ip_addr != null) {
            h2 = other.ip_addr.hashCode();
        }
        int n = h1 < h2 ? -1 : (rc = h1 > h2 ? 1 : 0);
        return rc != 0 ? rc : (this.port < other.port ? -1 : (this.port > other.port ? 1 : 0));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        int retval = this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            String host_name = null;
            if (resolve_dns) {
                try {
                    host_name = DnsCache.ResolveAddress(this.ip_addr);
                }
                catch (UnknownHostException ex) {
                    Logger.getLogger(Address.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                host_name = this.ip_addr.getHostAddress();
            }
            this.appendShortName(host_name, sb);
        }
        sb.append(":" + this.port);
        return sb.toString();
    }

    private void appendShortName(String hostname, StringBuilder sb) {
        int index = hostname.indexOf(46);
        if (hostname == null) {
            return;
        }
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index - 0));
        } else {
            sb.append(hostname);
        }
    }

    public final Object clone() {
        Address ret = null;
        ret = new Address(this.ip_addr.getHostAddress(), this.port);
        if (this.additional_data != null && ret != null) {
            ret.additional_data = new byte[this.additional_data.length];
            System.arraycopy(this.additional_data, 0, ret.additional_data, 0, this.additional_data.length);
        }
        return ret;
    }

    public final void DeserializeLocal(ObjectInput reader) throws UnknownHostException, IOException {
        int bytesToRead = reader.readInt();
        if (bytesToRead > 0) {
            byte[] ip = new byte[bytesToRead];
            reader.read(ip, 0, bytesToRead);
            if (ip != null) {
                try {
                    this.ip_addr = InetAddress.getByAddress(ip);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.port = reader.readInt();
        bytesToRead = reader.readInt();
        if (bytesToRead > 0) {
            this.additional_data = new byte[bytesToRead];
            reader.read(this.additional_data, 0, bytesToRead);
        }
    }

    public final void SerializeLocal(ObjectOutput writer) throws IOException {
        byte[] ip;
        byte[] byArray = ip = this.ip_addr != null ? Address.ParseIPAddress(this.ip_addr.getHostAddress()) : null;
        if (ip != null) {
            writer.writeInt(ip.length);
            writer.write(ip);
        } else {
            writer.writeInt(0);
        }
        writer.writeInt(this.port);
        if (this.additional_data != null) {
            writer.writeInt(this.additional_data.length);
            writer.write(this.additional_data);
        } else {
            writer.writeInt(0);
        }
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        byte[] ip = this.convertToByteArray((short[])reader.readObject());
        if (ip != null) {
            try {
                this.ip_addr = InetAddress.getByAddress(ip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.port = reader.readInt();
        this.additional_data = (byte[])reader.readObject();
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        byte[] ip = this.ip_addr != null ? Address.ParseIPAddress(this.ip_addr.getHostAddress()) : null;
        writer.writeObject((Object)ip);
        writer.writeInt(this.port);
        writer.writeObject((Object)this.additional_data);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        byte[] ip = this.ip_addr != null ? Address.ParseIPAddress(this.ip_addr.getHostAddress()) : null;
        writer.WriteObject((Object)ip);
        writer.Write(this.port);
        writer.WriteObject((Object)this.additional_data);
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        byte[] ip = (byte[])reader.ReadObject();
        if (ip != null) {
            try {
                this.ip_addr = InetAddress.getByAddress(ip);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.port = reader.ReadInt32();
        this.additional_data = (byte[])reader.ReadObject();
    }

    public static Address readAddress(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        byte isNull = reader.readByte();
        if (isNull == 1) {
            return null;
        }
        Address newAddr = new Address();
        newAddr.deserialize(reader);
        return newAddr;
    }

    public static void writeAddress(NCacheObjectOutput writer, Address addr) throws IOException {
        int isNull = 1;
        if (addr == null) {
            writer.write(isNull);
        } else {
            isNull = 0;
            writer.write(isNull);
            addr.serialize(writer);
        }
    }

    private byte[] convertToByteArray(short[] inputArray) {
        if (inputArray == null) {
            return null;
        }
        byte[] outputArray = new byte[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            outputArray[i] = (byte)inputArray[i];
        }
        return outputArray;
    }
}

