/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Monitoring;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Monitoring.MonitorableEntity;
import Alachisoft.NCache.Common.Monitoring.MonitoringConfigManager;
import Alachisoft.NCache.Common.ServiceConfiguration;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CounterIDMap;
import com.alachisoft.ncache.common.caching.statistics.monitoring.PublisherContextMetaPublisher;
import com.alachisoft.ncache.common.monitoring.CounterDataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMetadata;
import com.alachisoft.ncache.common.monitoring.CounterMetadataCollection;
import com.alachisoft.ncache.common.monitoring.CounterMonitorableEntity;
import com.alachisoft.ncache.common.monitoring.CounterType;
import com.alachisoft.ncache.common.monitoring.ICollector;
import com.alachisoft.ncache.common.monitoring.IntervalCounterDataCollection;
import com.alachisoft.ncache.common.monitoring.MetricsException;
import com.alachisoft.ncache.common.monitoring.MetricsTransporter;
import com.alachisoft.ncache.common.monitoring.MetricsTransporterFactory;
import com.alachisoft.ncache.common.monitoring.MonitorableEntitiesDataStore;
import com.alachisoft.ncache.common.monitoring.MonitoringEntityType;
import com.alachisoft.ncache.common.monitoring.PublishCountersDataResult;
import com.alachisoft.ncache.common.monitoring.Publisher;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangible.RefObject;

public class MetricsPublisher
implements IDisposable {
    private long startTime = 0L;
    private long _waitIntervalTime = 1L;
    private final long _resetWaitTime = 1L;
    private long _increment = 1L;
    private long _incrementPercentage = 5L;
    private Object _mutex = new Object();
    private Thread _dataCollector;
    private Thread _dataPublisher;
    private boolean stopPublishing = false;
    private boolean _metaDataRequired = true;
    private boolean _publishMetadata = true;
    private CounterIDMap _counterIdMap;
    private HashMap<MonitoringEntityType, ArrayList<MonitorableEntity>> _monitorableEntities = new HashMap();
    private MonitorableEntitiesDataStore _entitiesDataStore = new MonitorableEntitiesDataStore(2);
    private ArrayList<IntervalCounterDataCollection> _intervalCounterCollection = new ArrayList();
    private MetricsTransporterFactory factoryInstance;
    private MetricsTransporter _transporter;
    private PublisherContextMetaPublisher _contextMetaPublisher;
    private HashMap<String, MetricsException> _exceptionLogger = new HashMap();
    private Map<String, ICollector> _systemMetricsDictionary = new HashMap<String, ICollector>();
    private String privateSessionId;
    private String serviceBindedIp = null;
    private String privateCacheConfigID;
    private static MetricsPublisher privateInstance;
    private CounterMetadataCollection privateCounterMetadataCollection;
    private ILogger privateNCacheLog;
    private String privateNCacheVersion;
    private Map<String, ICollector> privateSystemMetricsDictionary;

    public final long getIntervalTime() {
        return this._waitIntervalTime;
    }

    public final void setIntervalTime(long ticks) {
        this._waitIntervalTime = ticks;
    }

    public final long getIncrementPercentage() {
        return this._incrementPercentage;
    }

    public final void setIncrementPercentage(long value) {
        this._incrementPercentage = value;
    }

    public final String getSessionId() {
        return this.privateSessionId;
    }

    public final void setSessionId(String value) {
        this.privateSessionId = value;
    }

    public final String getCacheConfigID() {
        return this.privateCacheConfigID;
    }

    public final void setCacheConfigID(String value) {
        this.privateCacheConfigID = value;
    }

    public static MetricsPublisher getInstance() {
        return privateInstance;
    }

    private static void setInstance(MetricsPublisher value) {
        privateInstance = value;
    }

    public final CounterMetadataCollection getCounterMetadataCollection() {
        return this.privateCounterMetadataCollection;
    }

    public final void setCounterMetadataCollection(CounterMetadataCollection value) {
        this.privateCounterMetadataCollection = value;
    }

    public final ILogger getNCacheLog() {
        return this.privateNCacheLog;
    }

    public final void setNCacheLog(ILogger value) {
        this.privateNCacheLog = value;
    }

    public final String getNCacheVersion() {
        return this.privateNCacheVersion;
    }

    public final void setNCacheVersion(String value) {
        this.privateNCacheVersion = value;
    }

    public final Map<String, ICollector> getSystemMetricsDictionary() {
        return this.privateSystemMetricsDictionary;
    }

    public final void setSystemMetricsDictionary(Map<String, ICollector> value) {
        this.privateSystemMetricsDictionary = value;
    }

    public MetricsPublisher(MetricsTransporterFactory factory, PublisherContextMetaPublisher contextMetaPublisher) {
        this.setNCacheVersion("5.1");
        this.factoryInstance = factory;
        this._contextMetaPublisher = contextMetaPublisher;
    }

    private void InitializedTrasnpoter() throws Exception {
        if (this._transporter == null) {
            this._transporter = this.factoryInstance.Create();
        }
        if (this._transporter != null && !this._transporter.getIsConnected()) {
            if (this.serviceBindedIp == null) {
                try {
                    this.loadLocalServerIp();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
            this._transporter.Connect(this.serviceBindedIp);
        }
    }

    public final void Initialize() {
        block3: {
            try {
                if (!new MonitoringConfigManager().getCongigFile()) {
                    throw new Exception("monitoring.ncconf not found");
                }
                this.StartGatheringData();
                this.StartPublishingData();
            }
            catch (Exception e) {
                if (this.getNCacheLog() == null) break block3;
                this.getNCacheLog().Error("Monitoring module", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean RegisterMonitorableEntity(MonitorableEntity monitorableEntity) {
        Object object = this._mutex;
        synchronized (object) {
            try {
                MonitoringEntityType type = monitorableEntity.getGetEntityType();
                ArrayList<Object> entities = new ArrayList();
                entities = this._monitorableEntities.get((Object)type);
                if (entities == null) {
                    ArrayList<MonitorableEntity> entityList = new ArrayList<MonitorableEntity>();
                    entityList.add(monitorableEntity);
                    this._monitorableEntities.put(type, entityList);
                }
                if (entities != null) {
                    entities.add(monitorableEntity);
                }
                return true;
            }
            catch (RuntimeException ex) {
                if (this.getNCacheLog() != null) {
                    this.getNCacheLog().Error("Monitoring Module", ex.toString());
                }
                return false;
            }
        }
    }

    public final void StartGatheringData() {
        if (this._dataCollector == null) {
            this._dataCollector = new Thread(new Runnable(){

                @Override
                public void run() {
                    MetricsPublisher.this.PerformDataCollection();
                }
            });
            this._dataCollector.setDaemon(true);
            this._dataCollector.start();
        }
    }

    public final void StopGatheringData() {
        if (this._dataCollector != null && this._dataCollector.isAlive()) {
            this.stopPublishing = true;
            this._dataCollector.interrupt();
        }
    }

    private void PerformDataCollection() {
        block13: {
            try {
                while (!this.stopPublishing) {
                    try {
                        for (Map.Entry<MonitoringEntityType, ArrayList<MonitorableEntity>> registeredEntities : this._monitorableEntities.entrySet()) {
                            switch (registeredEntities.getKey()) {
                                case Stats: {
                                    this.ProcessCounterStats(registeredEntities.getValue());
                                    this.StoreStats();
                                    break;
                                }
                                case APILogs: {
                                    break;
                                }
                                case Events: {
                                    break;
                                }
                            }
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.stopPublishing = true;
                        break;
                    }
                    catch (ThreadDeath e2) {
                        break;
                    }
                    catch (RuntimeException ex) {
                        if (this.getNCacheLog() == null) continue;
                        this.getNCacheLog().Error("Data Collector", ex.toString());
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.getNCacheLog() == null) break block13;
                this.getNCacheLog().Error("Data Collector", ex.toString());
            }
        }
    }

    private void ProcessCounterStats(ArrayList<MonitorableEntity> registeredEntities) {
        for (MonitorableEntity entity : registeredEntities) {
            if (this._metaDataRequired && entity.getIsPrimary()) {
                this.CollectCountersMetadata(entity);
                this._metaDataRequired = false;
            }
            this.CollectCounterData((CounterMonitorableEntity)entity);
        }
    }

    private void StoreStats() {
        IntervalCounterDataCollection intervalCollection = this.MergeDataFromModules();
        this._entitiesDataStore.AddCounterData(intervalCollection);
    }

    private IntervalCounterDataCollection MergeDataFromModules() {
        HashMap<Short, Double> data = new HashMap<Short, Double>();
        boolean fromreplica = false;
        Publisher publisher = Publisher.NCacheClient;
        Date dateTime = new Date(0L);
        String instanceName = null;
        try {
            for (IntervalCounterDataCollection intCollection : this._intervalCounterCollection) {
                for (Map.Entry<Short, Double> val : intCollection.getValues().entrySet()) {
                    if (data.containsKey(val.getKey())) continue;
                    data.put(val.getKey(), val.getValue());
                }
                dateTime = intCollection.getTimestamp();
                fromreplica = intCollection.getFromReplica();
                publisher = intCollection.getPublisherType();
                instanceName = intCollection.getInstanceName();
            }
            for (Short id : this._counterIdMap.getCounterIds()) {
                if (data.containsKey(id)) continue;
                data.put(id, -10.0);
            }
            this._intervalCounterCollection.clear();
            IntervalCounterDataCollection tempVar = new IntervalCounterDataCollection();
            tempVar.setValues(data);
            tempVar.setTimestamp(dateTime);
            tempVar.setFromReplica(fromreplica);
            tempVar.setPublisherType(publisher);
            tempVar.setInstanceName(instanceName);
            return tempVar;
        }
        catch (RuntimeException ex) {
            if (this.getNCacheLog() != null) {
                this.getNCacheLog().Error("Monitoring Module", ex.getMessage());
            }
            throw ex;
        }
    }

    private void CollectCounterData(CounterMonitorableEntity entity) {
        try {
            if (this._metaDataRequired) {
                return;
            }
            IntervalCounterDataCollection dataCollection = entity.getData();
            this.CollectSystemCounterData(dataCollection);
            this._intervalCounterCollection.add(dataCollection);
        }
        catch (RuntimeException ex) {
            if (this.getNCacheLog() != null) {
                this.getNCacheLog().Error("Monitoring Module", ex.toString());
            }
            throw ex;
        }
    }

    private void CollectSystemCounterData(IntervalCounterDataCollection dataCollection) {
        try {
            if (this._systemMetricsDictionary != null && this._systemMetricsDictionary.size() != 0) {
                for (Map.Entry<String, ICollector> item : this._systemMetricsDictionary.entrySet()) {
                    dataCollection.getValues().put(this._counterIdMap.getCounterID(item.getKey()), item.getValue().Collectstats());
                }
            }
        }
        catch (RuntimeException ex) {
            if (this.getNCacheLog() != null) {
                this.getNCacheLog().Error("Monitoring Module", ex.toString());
            }
            throw ex;
        }
    }

    private void CollectSystemCountersMetadata(CounterMetadataCollection counterMetadata) {
        if (this._systemMetricsDictionary != null && this._systemMetricsDictionary.size() != 0) {
            for (Map.Entry<String, ICollector> item : this._systemMetricsDictionary.entrySet()) {
                CounterMetadata tempVar = new CounterMetadata();
                tempVar.setName(item.getKey());
                tempVar.setType(CounterType.RateOfCounter);
                tempVar.setDescription(item.getValue().getName());
                tempVar.setCategory(counterMetadata.getCategory());
                counterMetadata.getCounters().add(tempVar);
            }
        }
    }

    private void CollectCountersMetadata(MonitorableEntity monitorableEntity) {
        CounterMonitorableEntity entity = (CounterMonitorableEntity)monitorableEntity;
        this.setCounterMetadataCollection(entity.getMetadata());
        if (entity.getPublisherType() == Publisher.NCacheClient) {
            this.getCounterMetadataCollection().setCacheConfigID(this.getCacheConfigID());
        }
        this.CollectSystemCountersMetadata(this.getCounterMetadataCollection());
        if (this.getCounterMetadataCollection() == null) {
            if (this.getNCacheLog() != null) {
                this.getNCacheLog().Error("Monitoring Module", "Meta info is not populated.");
            }
            throw new RuntimeException("No meta info is added.");
        }
        this._counterIdMap = new CounterIDMap();
        this._counterIdMap.assignAndAddCounters(this.getCounterMetadataCollection().getCounters());
    }

    public final void StartPublishingData() {
        if (this._dataPublisher == null) {
            this._dataPublisher = new Thread(new Runnable(){

                @Override
                public void run() {
                    MetricsPublisher.this.PublishData();
                }
            });
            this._dataPublisher.setDaemon(true);
            this._dataPublisher.start();
        }
    }

    public final void StopPublishingData() {
        if (this._dataPublisher != null && this._dataPublisher.isAlive()) {
            this.stopPublishing = true;
            this._dataPublisher.interrupt();
        }
    }

    private void UpdateWaitTime() {
        if (this.getIntervalTime() > 0L) {
            long addititionalTime = (long)Math.pow(this._increment, this.getIncrementPercentage());
            this.setIntervalTime(addititionalTime + this.getIncrementPercentage());
            ++this._increment;
        }
    }

    private void ResetWaitInterval() {
        this.setIntervalTime(1L);
    }

    private void PublishData() {
        while (!this.stopPublishing) {
            try {
                if (this.stopPublishing) break;
                this.InitializedTrasnpoter();
                Thread.sleep(ServiceConfiguration.getMetricsMonitorPublishingInterval().getTotalMiliSeconds());
                this.ResetWaitInterval();
                if (this.stopPublishing) break;
                this.PublishMetadata();
                this.PublishCounterData();
            }
            catch (InterruptedException e) {
                this.stopPublishing = true;
                if (this._transporter == null) break;
                this._transporter.dispose();
                break;
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(this.getIntervalTime() * 1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                this.UpdateWaitTime();
                if (this.getNCacheLog() == null) continue;
                MetricsException metricsException = new MetricsException();
                metricsException = this._exceptionLogger.get(ex.getClass().toString());
                if (metricsException == null) {
                    MetricsException tempVar = new MetricsException();
                    tempVar.setTimeStamp(NCDateTime.getUTCNow());
                    tempVar.setException(ex);
                    tempVar.setLastLogTime(NCDateTime.getUTCNow());
                    this._exceptionLogger.put(ex.getClass().toString(), tempVar);
                    if (this.getNCacheLog() == null) continue;
                    this.getNCacheLog().Error("Metrics Publisher", ex.toString());
                    continue;
                }
                metricsException = this._exceptionLogger.get(ex.getClass().toString());
                metricsException.setTimeStamp(NCDateTime.getUTCNow());
                metricsException.setException(ex);
                if (!metricsException.CompareAndUpdateifRequired()) continue;
                if (this.getNCacheLog() != null) {
                    this.getNCacheLog().Error("Metrics Publisher", ex.toString());
                }
                metricsException.setLastLogTime(NCDateTime.getUTCNow());
            }
        }
    }

    private void PublishMetadata() throws Exception {
        if (this._publishMetadata) {
            this._contextMetaPublisher.PublishMetadata(this._transporter);
            if (!this._metaDataRequired) {
                this._transporter.PublishMetadata(this.getSessionId(), this.getCounterMetadataCollection());
            }
            this._publishMetadata = false;
        }
    }

    private void PublishCounterData() throws Exception {
        if (this._publishMetadata) {
            return;
        }
        long refStartTime = this.startTime;
        RefObject<Long> tempRef_refStartTime = new RefObject<Long>(refStartTime);
        ArrayList<IntervalCounterDataCollection> dataToBePublished = this._entitiesDataStore.GetStatsData(tempRef_refStartTime);
        refStartTime = (Long)tempRef_refStartTime.argvalue;
        if (dataToBePublished != null && dataToBePublished.size() > 0) {
            boolean isReplica = false;
            CounterDataCollection tempVar = new CounterDataCollection();
            tempVar.setValues(dataToBePublished);
            tempVar.setVersion(this.getNCacheVersion());
            tempVar.setCategory(this.getCounterMetadataCollection().getCategory());
            tempVar.setInstanceName(this.getCounterMetadataCollection().getInstanceName());
            tempVar.setFromReplica(this.getCounterMetadataCollection().getFromReplica());
            tempVar.setCacheUniqueID(Long.toString(ProcessHandle.current().pid()));
            CounterDataCollection counterDataCollection = tempVar;
            PublishCountersDataResult result = this._transporter.PublishData(this.getSessionId(), counterDataCollection);
            if (result == PublishCountersDataResult.CountersSessionExpired || result == PublishCountersDataResult.CountersMetaDataNotPersisted) {
                this._publishMetadata = true;
            }
            this.startTime = refStartTime;
        }
    }

    @Override
    public final void dispose() {
        this.stopPublishing = true;
        this.StopGatheringData();
        this.StopPublishingData();
        if (this._entitiesDataStore != null) {
            try {
                this._entitiesDataStore.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._transporter != null) {
            this._transporter.dispose();
        }
        this._contextMetaPublisher = null;
    }

    public void loadLocalServerIp() throws ConfigurationException {
        this.serviceBindedIp = AppUtil.getLocalServerIp();
    }
}

