/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Monitoring;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Monitoring.ClientNode;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class ClientProcessStats
extends ClientNode
implements Comparable,
InternalCompactSerializable {
    private String _processID;
    private float _bytesSent;
    private float _bytesReceived;
    private String _serverIPAddress;

    public ClientProcessStats(String clientID, Address address, float byteSent, float byteReceived, String serverIPAddress) {
        this.setAddress(address);
        this.setClientID(clientID);
        int lastIndex = clientID.lastIndexOf(":");
        if (lastIndex != -1 && lastIndex != clientID.length() - 1) {
            this._processID = clientID.substring(lastIndex + 1, lastIndex + 1 + clientID.length() - lastIndex - 1);
        }
        this._bytesReceived = byteReceived;
        this._bytesSent = byteSent;
        this._serverIPAddress = serverIPAddress;
    }

    public final String getServerIPAddress() {
        return this._serverIPAddress;
    }

    public final void setServerIPAddress(String value) {
        this._serverIPAddress = value;
    }

    public final String getProcessID() {
        return this._processID;
    }

    public final float getBytesSent() {
        return this._bytesSent;
    }

    public final void setBytesSent(float value) {
        this._bytesSent = value;
    }

    public final float getBytesReceived() {
        return this._bytesReceived;
    }

    public final void setBytesReceived(float value) {
        this._bytesReceived = value;
    }

    public final int compareTo(Object obj) {
        ClientProcessStats clientProcessStats = (ClientProcessStats)(obj instanceof ClientProcessStats ? obj : null);
        if (clientProcessStats == null) {
            return -1;
        }
        int result = 0;
        result = this._processID.compareTo(clientProcessStats._processID);
        if (result != 0) {
            result = this.getAddress().getIpAddress().toString().compareTo(clientProcessStats.getAddress().getIpAddress().toString());
        }
        if (result != 0) {
            result = new Integer(this.getAddress().getPort()).toString().compareTo(new Integer(this.getAddress().getPort()).toString());
        }
        if (result != 0) {
            result = this._serverIPAddress.compareTo(clientProcessStats.getServerIPAddress());
        }
        if (result != 0) {
            result = new Float(this._bytesSent).compareTo(Float.valueOf(clientProcessStats.getBytesSent()));
        }
        if (result != 0) {
            result = new Float(this._bytesReceived).compareTo(Float.valueOf(clientProcessStats.getBytesReceived()));
        }
        return result;
    }

    @Override
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._processID = (String)Common.readAs(reader.ReadObject(), String.class);
        this._bytesSent = reader.ReadSingle();
        this._bytesReceived = reader.ReadSingle();
        this._serverIPAddress = (String)Common.readAs(reader.ReadObject(), String.class);
        super.Deserialize(reader);
    }

    @Override
    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._processID);
        writer.Write(this._bytesSent);
        writer.Write(this._bytesReceived);
        writer.WriteObject((Object)this._serverIPAddress);
        super.Serialize(writer);
    }
}

