/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Logger;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.DirectoryUtil;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JFormatter;
import Alachisoft.NCache.Common.Logger.JLevel;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import Alachisoft.NCache.Common.ServicePropValues;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangible.RefObject;

public class JLogger
implements ILogger {
    private static final String DIRNAME = ServicePropValues.LOGS_FOLDER;
    private static String s_configDir = "";
    private static int bufferDefaultSize = 1;
    private static String _nodeIP = "";
    private final String NEW_LINE = "\r\n";
    private Logger logger;
    private String _path = "";
    private String _loggerName = null;
    private int _limit = 5000000;
    private int _numLogFiles = 1000;
    private String _logFileNamePattern = "log";
    private boolean _append = true;

    public int getLimit() {
        return this._limit;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public int getNumLogFiles() {
        return this._numLogFiles;
    }

    public void setNumLogFiles(int count) {
        this._numLogFiles = count;
    }

    public String getLogFileNamePattern() {
        return this._logFileNamePattern;
    }

    public void setLogFileNamePattern(String pattern) {
        this._logFileNamePattern = pattern;
    }

    public boolean getAppend() {
        return this._append;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    @Override
    public String Initialize(Map properties, String partitionID, String cacheName) throws Exception {
        return this.Initialize(properties, partitionID, cacheName, false, false);
    }

    @Override
    public final String Initialize(Map properties, String partitionID, String cacheName, boolean isStartedAsMirror, boolean inproc) throws Exception {
        if (this.logger != null) {
            throw new Exception("Multiple Initialize calls for same logger");
        }
        if (this._loggerName != null) {
            return this._loggerName;
        }
        try {
            this._loggerName = cacheName;
            if (partitionID != null && partitionID.length() > 0) {
                this._loggerName = this._loggerName + "-" + partitionID;
            }
            if (isStartedAsMirror) {
                this._loggerName = this._loggerName + "-replica";
            }
            if (inproc && !isStartedAsMirror) {
                this._loggerName = this._loggerName + "." + ManagementFactory.getRuntimeMXBean().getName();
            }
            String LogExceptions = "";
            if (this._loggerName.equals("LogExceptions")) {
                LogExceptions = "/LogExceptions";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            String currTime = dateFormat.format(date).replace('/', '-').replace(':', '-').replace(' ', '-');
            boolean defaultPath = true;
            String initialPath = "";
            if (properties != null && properties.containsKey("log-path") && !(initialPath = (String)properties.get("log-path")).equals("")) {
                boolean bl = defaultPath = !this.isValidLocation(initialPath, cacheName);
            }
            if (defaultPath) {
                initialPath = this.GetLogPath();
            }
            String fileName = initialPath + LogExceptions + "/" + this._loggerName + "_" + currTime + "_" + _nodeIP + "_%g.txt";
            PrintStream out = new PrintStream(fileName.replace("%g", "0"));
            out.print(String.format("%-28s", "TIMESTAMP") + String.format("%-45s", "LOGGERNAME") + String.format("%-35s", "THREAD-ID") + String.format("%-20s", "LEVEL") + "MESSAGE\r\n");
            out.close();
            this.ConfigureLogger(fileName);
            if (properties != null) {
                if (properties.containsKey("trace-errors") && Boolean.parseBoolean(properties.get("trace-errors").toString())) {
                    this.SetLevel(JLevel.Error);
                }
                if (properties.containsKey("trace-notices") && Boolean.parseBoolean(properties.get("trace-notices").toString())) {
                    this.SetLevel(JLevel.INFO);
                }
                if (properties.containsKey("trace-warnings") && Boolean.parseBoolean(properties.get("trace-warnings").toString())) {
                    this.SetLevel(JLevel.WARNING);
                }
                if (properties.containsKey("trace-debug") && Boolean.parseBoolean(properties.get("trace-debug").toString())) {
                    this.SetLevel(JLevel.ALL);
                }
                if (properties.containsKey("enabled") && !Boolean.parseBoolean(properties.get("trace-errors").toString())) {
                    this.SetLevel(JLevel.OFF);
                }
            } else {
                this.SetLevel(JLevel.WARNING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._loggerName;
    }

    public final void Initialize(LoggerNames loggerNameEnum, boolean isEventLogs) throws Exception {
        if (this.logger != null) {
            throw new Exception("Multiple Initialize calls for same logger");
        }
        this._loggerName = loggerNameEnum.toString();
        String filepath = "";
        RefObject<String> tempRef_filepath = new RefObject<String>(filepath);
        boolean tempVar = !DirectoryUtil.SearchGlobalDirectory(ServicePropValues.LOGS_FOLDER, false, tempRef_filepath);
        filepath = (String)tempRef_filepath.argvalue;
        if (tempVar) {
            try {
                RefObject<String> tempRef_filepath2 = new RefObject<String>(filepath);
                DirectoryUtil.SearchLocalDirectory(ServicePropValues.LOGS_FOLDER, true, tempRef_filepath2);
                filepath = (String)tempRef_filepath2.argvalue;
            }
            catch (Exception ex) {
                throw new Exception("Unable to initialize the log file", ex);
            }
        }
        filepath = Common.combinePath(filepath, loggerNameEnum.toString().toLowerCase());
        if (!new File(filepath).isDirectory()) {
            new File(filepath).mkdir();
        }
        filepath = Common.combinePath(filepath, loggerNameEnum.toString().toLowerCase());
        this.ConfigureLogger(filepath);
    }

    @Override
    public final void Initialize(LoggerNames loggerName) throws Exception {
        if (loggerName != LoggerNames.Licence) {
            this.Initialize(loggerName, null);
        }
    }

    @Override
    public final void Initialize(LoggerNames loggerNameEnum, String cacheName) throws Exception {
        if (this.logger != null) {
            throw new Exception("Multiple Initialize calls for same logger");
        }
        if (cacheName == null) {
            cacheName = "";
        }
        Object filename = "";
        this._loggerName = loggerNameEnum.toString();
        if (loggerNameEnum != LoggerNames.ClientLogs) {
            filename = cacheName;
        } else {
            filename = this._loggerName.toLowerCase() + "." + cacheName + "." + ProcessHandle.current().pid();
            this._loggerName = cacheName + ProcessHandle.current().pid() + new Date();
        }
        String localMachine = null;
        try {
            localMachine = InetAddress.getLocalHost().getHostAddress().trim();
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception(unknownHostException.toString());
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yy_HH-mm-ss");
        filename = ((String)filename).isEmpty() ? (loggerNameEnum == LoggerNames.LoaderService ? format.format(new Date()) + "_" + localMachine + "_java_%g.txt" : format.format(new Date()) + "_" + localMachine + "_%g.txt") : (loggerNameEnum == LoggerNames.LoaderService ? (String)filename + "." + format.format(new Date()) + "_" + localMachine + "_java_%g.txt" : (String)filename + "." + format.format(new Date()) + "_" + localMachine + "_%g.txt");
        String filepath = "";
        RefObject<String> tempRef_filepath = new RefObject<String>(filepath);
        boolean tempVar = DirectoryUtil.SearchGlobalDirectory(ServicePropValues.LOGS_FOLDER, false, tempRef_filepath);
        filepath = (String)tempRef_filepath.argvalue;
        if (!tempVar) {
            try {
                RefObject<String> tempRef_filepath2 = new RefObject<String>(filepath);
                DirectoryUtil.SearchLocalDirectory(ServicePropValues.LOGS_FOLDER, true, tempRef_filepath2);
                filepath = (String)tempRef_filepath2.argvalue;
            }
            catch (Exception ex) {
                throw new Exception("Unable to initialize the log file", ex);
            }
        }
        filepath = Common.combinePath(filepath, loggerNameEnum.toString());
        if (!new File(filepath).isDirectory()) {
            new File(filepath).mkdir();
        }
        if (loggerNameEnum == LoggerNames.LoaderService) {
            this.configureLoggerForLoader(filepath, (String)filename);
        } else {
            filepath = Common.combinePath(filepath, new String[]{filename});
            this.ConfigureLogger(filepath);
            this.writeHeader(filepath);
        }
    }

    private void writeHeader(String filepath) throws IOException {
        PrintStream out = new PrintStream(filepath.replace("%g", "0"));
        out.print(String.format("%-28s", "TIMESTAMP") + String.format("%-45s", "LOGGERNAME") + String.format("%-35s", "THREAD-ID") + String.format("%-20s", "LEVEL") + "MESSAGE\r\n");
        out.close();
    }

    private void configureLoggerForLoader(String filepath, String filename) throws IOException {
        File dir = new File(filepath);
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(JLogger.this._loggerName) && name.endsWith("_0.txt");
            }
        });
        if (matches.length == 0) {
            filename = this._loggerName + "." + (String)filename;
            filepath = Common.combinePath(filepath, new String[]{filename});
            this.setNumLogFiles(1);
            this.ConfigureLogger(filepath);
            this.writeHeader(filepath);
        } else {
            filepath = matches[0].getPath();
            this.setNumLogFiles(1);
            this.ConfigureLogger(filepath);
        }
    }

    private void ConfigureLogger(String filePath) throws IOException {
        this.logger = Logger.getLogger(this._loggerName);
        this.logger.setUseParentHandlers(false);
        this.setLogFileNamePattern(filePath);
        FileHandler fh = new FileHandler(this.getLogFileNamePattern(), this.getLimit(), this.getNumLogFiles(), this.getAppend());
        fh.setFormatter(new JFormatter());
        this.logger.addHandler(fh);
    }

    @Override
    public final void SetLevel(String levelName) {
        this.logger.setLevel(JLevel.parse(levelName));
    }

    public final void SetLevel(Level level) {
        this.logger.setLevel(level);
    }

    @Override
    public final void Error(String message) {
        this.logger.log(JLevel.Error, message);
    }

    @Override
    public final void Fatal(String message) {
        this.logger.log(JLevel.SEVERE, message);
    }

    @Override
    public final void CriticalInfo(String message) {
        this.logger.log(JLevel.CriticalInfo, message);
    }

    @Override
    public final void Info(String message) {
        this.logger.info(message);
    }

    @Override
    public final void Debug(String message) {
        this.logger.fine(message);
    }

    @Override
    public final void Warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public final boolean getIsInfoEnabled() {
        return this.logger.isLoggable(JLevel.INFO);
    }

    @Override
    public final boolean getIsErrorEnabled() {
        return this.logger.isLoggable(JLevel.Error);
    }

    @Override
    public final boolean getIsWarnEnabled() {
        return this.logger.isLoggable(JLevel.WARNING);
    }

    @Override
    public final boolean getIsDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public final boolean getIsFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public final String GetLogPath() {
        if (this._path.length() < 1) {
            this._path = s_configDir;
        }
        try {
            if (!new File(this._path).isDirectory()) {
                new File(this._path).mkdir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._path;
    }

    public final boolean isValidLocation(String location, String cache) {
        try {
            Exception ex = new Exception("Invalid Directory Specified");
            if (location.equals("")) {
                throw ex;
            }
            if (new File(location).isDirectory()) {
                return true;
            }
            throw ex;
        }
        catch (Exception e) {
            EventLogger.LogEvent("NCache", "The custom path given for logging cache :\"" + cache + "\" info data is not valid", EventType.ERROR, (short)1, 1017);
            return false;
        }
    }

    private void RemoveAllAppender() {
    }

    public final boolean[] ReadConfig(RefObject<Integer> bufferAppender) {
        try {
            String EnableLogs = "False";
            String EnableDetailedLogs = "False";
            String BufferSize = "False";
            try {
                bufferAppender.argvalue = BufferSize != null ? Integer.valueOf(Integer.parseInt(BufferSize)) : Integer.valueOf(bufferDefaultSize);
            }
            catch (Exception e) {
                bufferAppender.argvalue = bufferDefaultSize;
            }
            if (EnableDetailedLogs == null && EnableLogs == null) {
                return new boolean[]{false, false};
            }
            if (EnableDetailedLogs != null && EnableLogs == null) {
                return new boolean[]{false, Boolean.parseBoolean(EnableDetailedLogs)};
            }
            if (EnableDetailedLogs == null && EnableLogs != null) {
                return new boolean[]{Boolean.parseBoolean(EnableLogs), false};
            }
            return new boolean[]{Boolean.parseBoolean(EnableLogs), Boolean.parseBoolean(EnableDetailedLogs)};
        }
        catch (Exception ex) {
            bufferAppender.argvalue = bufferDefaultSize;
            return new boolean[]{false, false};
        }
    }

    public final boolean[] ReadClientConfig(RefObject<Integer> bufferAppender) {
        try {
            String EnableLogs = System.getProperty("ENABLE_CLIENT_LOGS");
            String EnableDetailedLogs = System.getProperty("ENABLE_DETAILED_CLIENT_LOGS");
            String BufferSize = System.getProperty("BufferSize");
            try {
                bufferAppender.argvalue = BufferSize != null ? Integer.valueOf(Integer.parseInt(BufferSize)) : Integer.valueOf(bufferDefaultSize);
            }
            catch (Exception e) {
                bufferAppender.argvalue = bufferDefaultSize;
            }
            if (EnableDetailedLogs == null && EnableLogs == null) {
                return new boolean[]{false, false};
            }
            if (EnableDetailedLogs != null && EnableLogs == null) {
                return new boolean[]{false, Boolean.parseBoolean(EnableDetailedLogs)};
            }
            if (EnableDetailedLogs == null && EnableLogs != null) {
                return new boolean[]{Boolean.parseBoolean(EnableLogs), false};
            }
            return new boolean[]{Boolean.parseBoolean(EnableLogs), Boolean.parseBoolean(EnableDetailedLogs)};
        }
        catch (Exception ex) {
            bufferAppender.argvalue = bufferDefaultSize;
            return new boolean[]{false, false};
        }
    }

    @Override
    public final void Flush() {
    }

    @Override
    public final void close() {
        for (Handler handler : this.logger.getHandlers()) {
            handler.close();
            handler.flush();
            this.logger.removeHandler(handler);
        }
        this.SetLevel("OFF");
    }

    @Override
    public final void Error(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.Error(module + String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void Fatal(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.Fatal(module + String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void CriticalInfo(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.CriticalInfo(module + String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void Info(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.Info(module + String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void Debug(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.Debug(module + String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void Warn(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.Warn(String.format("%" + space2 + "s", " ") + message);
    }

    @Override
    public final void DevTrace(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public final void DevTrace(String module, String message) {
        int space2 = 50;
        if (module.length() == 0) {
            space2 = 4;
        } else {
            space2 = 50 - module.length();
            if (space2 <= 0) {
                space2 = 40;
            }
        }
        this.DevTrace(String.format("%" + space2 + "s", " ") + message);
    }

    static {
        s_configDir = Common.getConfigPath();
        try {
            String strHostName = InetAddress.getLocalHost().getHostName();
            InetAddress addr = InetAddress.getByName(strHostName);
            _nodeIP = addr.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s_configDir = new File(s_configDir, DIRNAME).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

