/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Logger;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Event.NEvent;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Logger.IEventLogger;
import Alachisoft.NCache.Common.Logger.JLinuxLogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import Alachisoft.NCache.Common.Monitoring.EventViewerEvent;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;

public class EventLogger
implements NEventStart {
    private static long _instanceId = 0L;
    private static IEventLogger _eventlogger = null;
    private static JLogger _fileLogger = null;
    private static boolean recognizedOS = true;
    private static String lastLoggedEvent;
    private static NEvent _nevent;
    private static ArrayList<EventViewerEvent> _events;

    public static String getLastLoggedEvent() {
        return lastLoggedEvent;
    }

    public static void setLastLoggedEvent(String msg, String type) {
        lastLoggedEvent = type.concat(msg);
    }

    public static void Initialize(boolean isBridgeLog) {
        _events = new ArrayList();
        _fileLogger = new JLogger();
        lastLoggedEvent = new String();
        if (_eventlogger == null) {
            _eventlogger = new JLinuxLogger();
            recognizedOS = false;
            try {
                _fileLogger.Initialize(LoggerNames.EventLogs, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _eventlogger.setLogger(_fileLogger);
            if (!recognizedOS) {
                _eventlogger.LogEvent("OS is not recognized: " + System.getProperty("os.name"), EventType.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEvents(String name) {
        NEvent nEvent = _nevent;
        synchronized (nEvent) {
            _nevent.addNEventListners(new NEventStart(){

                @Override
                public Object hanleEvent(Object ... obj) throws SocketException, Exception {
                    return _events.add((EventViewerEvent)obj[0]);
                }
            }, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEvents(String name) {
        NEvent nEvent = _nevent;
        synchronized (nEvent) {
            _nevent.removeNEventListners(null);
        }
    }

    public static synchronized void LogEvent(String msg, EventType type) {
        EventLogger.LogEvent("NCache", msg, type, (short)-1, -1);
    }

    public static synchronized void LogEvent(String source, String msg, EventType type, short category, int eventid) {
        if (_eventlogger == null) {
            return;
        }
        EventLogger.setLastLoggedEvent(msg, type.toString());
        _eventlogger.LogEvent(msg, type);
        EventViewerEvent event = new EventViewerEvent();
        event.setInstanceId(eventid);
        event.setEventType(type);
        event.setMessage(msg);
        event.setSource(source);
        try {
            event.setGeneratedTime(new NCDateTime(new Date()));
        }
        catch (Exception ex) {
            EventLogger.LogEvent("NCache", ex.getMessage(), EventType.ERROR, (short)-1, -1);
        }
        _events.add(event);
    }

    public static synchronized EventViewerEvent[] getEventList() {
        EventViewerEvent[] eventList = new EventViewerEvent[_events.size()];
        return _events.toArray(eventList);
    }

    public static synchronized void clearEvents() {
        _events.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnLogEntryWritten(EventViewerEvent event) {
        NEvent nEvent = _nevent;
        synchronized (nEvent) {
            _events.add(event);
        }
    }

    @Override
    public Object hanleEvent(Object ... obj) throws SocketException, Exception {
        return _events.add((EventViewerEvent)obj[0]);
    }

    static {
        _nevent = new NEvent("OnEventLogEntry", _fileLogger);
    }
}

