/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.JSON;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.JSON.BinaryJsonValue;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.JSON.JsonDocumentUtil;
import Alachisoft.NCache.Common.JSON.UserObjectJsonValue;
import Alachisoft.NCache.Common.MemoryUtil;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.JSON.JsonBinaryFormatter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.Charset;

public class JsonHelper {
    public static ExtendedJsonValueBase getUserObjectJsonValue(Object item, boolean isCustomAttributeBaseSerialzed) throws OperationFailedException {
        String json = null;
        JsonValueBase possiblyJsonValue = (JsonValueBase)(item instanceof JsonValueBase ? item : null);
        json = possiblyJsonValue != null ? possiblyJsonValue.toString() : JsonBinaryFormatter.serializeObject((Object)item, (boolean)isCustomAttributeBaseSerialzed);
        return new UserObjectJsonValue(item, MemoryUtil.getStringSizeWithoutNetOverhead(json), MemoryUtil.getStringSize(json));
    }

    public static ExtendedJsonValueBase getBinaryJsonValue(Object serializableObject, boolean isCustomAtributeBaseSerialized) throws OperationFailedException {
        String json = new String();
        JsonValueBase possibleJsonValue = serializableObject instanceof JsonValueBase ? (JsonValueBase)serializableObject : null;
        json = possibleJsonValue != null ? possibleJsonValue.toString() : JsonBinaryFormatter.serializeObject((Object)serializableObject, (boolean)isCustomAtributeBaseSerialized);
        return new BinaryJsonValue(UserBinaryObject.createUserBinaryObject(json.getBytes(JsonBinaryFormatter.SERIALIZATION_CHARSET)));
    }

    public static ExtendedJsonValueBase getDeserializedJsonValue(ExtendedJsonValueBase jsonValueBase, int binarySize, int binaryInMemorySize, boolean isCustomAttributeBase) throws OperationFailedException {
        Object value = null;
        try {
            value = JsonBinaryFormatter.deserializeObject((String)jsonValueBase.toJson(), null);
        }
        catch (JsonProcessingException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return JsonDocumentUtil.ToExtendedJsonValueBase(value, binarySize, binaryInMemorySize);
    }

    public static Object GetSafeDeserializeValue(ExtendedJsonValueBase jsonValueBase) throws IOException, OperationFailedException {
        if (jsonValueBase instanceof UserObjectJsonValue) {
            return jsonValueBase.getValue();
        }
        return JsonBinaryFormatter.deserializeObject((String)jsonValueBase.toJson(), null);
    }

    public static ExtendedJsonValueBase getExtendedJsonValueBaseFromCollectionItem(CollectionItemProtocol.CollectionItem collectionItem) {
        return new BinaryJsonValue(UserBinaryObject.createUserBinaryObject(collectionItem.getDataList()));
    }

    public static JsonValueBase getJsonValueBaseFromCollectionItem(CollectionItemProtocol.CollectionItem collectionItem) {
        return JsonHelper.getExtendedJsonValueBaseFromCollectionItem(collectionItem);
    }

    public static UserBinaryObject createUserBinaryObject(JsonValueBase jsonValue) {
        return UserBinaryObject.createUserBinaryObject(jsonValue.toJson().getBytes(Charset.forName("UTF-8")));
    }

    public static ExtendedJsonValueBase getJsonValue(Object item, boolean inProc) throws OperationFailedException {
        ExtendedJsonValueBase jsonValue = inProc ? JsonHelper.getUserObjectJsonValue(item, false) : JsonHelper.getBinaryJsonValue(item, false);
        return jsonValue;
    }
}

