/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.JSON;

import Alachisoft.NCache.Common.JSON.ExtendedJsonValue;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import java.util.ArrayList;
import java.util.Date;

public class JsonDocumentUtil {
    public static ArrayList<JsonValueBase> ToJsonValueList(Iterable arrayList) {
        ArrayList<JsonValueBase> jsonList = new ArrayList<JsonValueBase>();
        for (Object value : arrayList) {
            JsonValueBase jsonValue = JsonDocumentUtil.ToJsonValueBase(value);
            jsonList.add(jsonValue);
        }
        return jsonList;
    }

    public static JsonValueBase ToJsonValueBase(Object value) {
        JsonValue jsonValue = null;
        if (JsonDocumentUtil.IsNumber(value)) {
            jsonValue = new JsonValue((Object)((Double)value));
        } else if (value.getClass().equals(Boolean.TYPE)) {
            jsonValue = new JsonValue((Object)((Boolean)value));
        } else if (value instanceof String || value instanceof Character) {
            jsonValue = new JsonValue(value.toString());
        } else if (value instanceof Date) {
            jsonValue = new JsonValue(((Date)value).toString());
        } else {
            throw new RuntimeException("Json type not supported.");
        }
        return jsonValue;
    }

    public static ExtendedJsonValueBase ToExtendedJsonValueBase(Object value, int binarySize, int binaryInMemorySize) {
        JsonValueBase jsonValue = (JsonValueBase)(value instanceof JsonValueBase ? value : null);
        if (jsonValue == null) {
            jsonValue = JsonDocumentUtil.ToJsonValueBase(value);
        }
        return new ExtendedJsonValue(jsonValue, binarySize, binaryInMemorySize);
    }

    public static boolean IsNumber(Object value) {
        if (value == null) {
            return false;
        }
        return Byte.TYPE.equals(value.getClass()) || Short.TYPE.equals(value.getClass()) || Integer.TYPE.equals(value.getClass()) || Long.TYPE.equals(value.getClass()) || Double.TYPE.equals(value.getClass());
    }
}

