/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.Enumerator;
import Alachisoft.NCache.Common.DataStructures.InstantaneousIndex;
import Alachisoft.NCache.Common.Stats.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import tangible.RefObject;

public class SlidingIndex<T>
implements AutoCloseable {
    private static final int MAX_OBSERVATION_INTERVAL = 300;
    private static final int MIN_OBSERVATION_INTERVAL = 1;
    ArrayList<InstantaneousIndex<T>> _mainIndex = new ArrayList();
    private int _observationInterval = 1;
    private long _entryIdSequence;
    private boolean _checkDuplication;

    public SlidingIndex(int interval) {
        this(interval, false);
    }

    public SlidingIndex(int interval, boolean checkDuplication) {
        if (interval > 1) {
            this._observationInterval = interval;
        }
        this._checkDuplication = checkDuplication;
        Clock.StartClock();
    }

    public int GetInterval() {
        return this._observationInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AddToIndex(T indexValue) {
        SlidingIndex slidingIndex = this;
        synchronized (slidingIndex) {
            long currentTime = Clock.getCurrentTimeInSeconds();
            long entryId = this._entryIdSequence++;
            InstantaneousIndex<T> indexEntry = null;
            if (this._mainIndex.size() == 0) {
                indexEntry = new InstantaneousIndex<T>();
                indexEntry.setEnableDuplicationCheck(this._checkDuplication);
                indexEntry.setClockTime(currentTime);
                this._mainIndex.add(indexEntry);
            } else {
                if (this._checkDuplication && this.CheckForDuplication(indexValue)) {
                    return false;
                }
                this.ExpireOldEnteries(currentTime);
                InstantaneousIndex<T> matchEntry = null;
                for (InstantaneousIndex<T> match : this._mainIndex) {
                    if (match.getClockTime() != currentTime) continue;
                    matchEntry = match;
                    break;
                }
                boolean newEntry = false;
                if (matchEntry != null) {
                    indexEntry = matchEntry;
                } else {
                    newEntry = true;
                    indexEntry = new InstantaneousIndex();
                    indexEntry.setEnableDuplicationCheck(this._checkDuplication);
                    indexEntry.setClockTime(currentTime);
                    this._mainIndex.add(indexEntry);
                }
            }
            indexEntry.AddEntry(entryId, indexValue);
        }
        return true;
    }

    private boolean CheckForDuplication(T activity) {
        if (!this._checkDuplication) {
            return false;
        }
        for (InstantaneousIndex<T> currentIndexEntry : this._mainIndex) {
            if (!currentIndexEntry.CheckDuplication(activity)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator<T> GetCurrentData() {
        SlidingIndex slidingIndex = this;
        synchronized (slidingIndex) {
            Enumerator enumerator = new Enumerator(this);
            return enumerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Enumerator<T> GetCurrentData(RefObject<Long> startTime, boolean getReplicatData) {
        SlidingIndex slidingIndex = this;
        synchronized (slidingIndex) {
            Enumerator enumerator = new Enumerator(this, startTime, getReplicatData);
            return enumerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExpireOldEnteries(long currentTime) {
        SlidingIndex slidingIndex = this;
        synchronized (slidingIndex) {
            ArrayList<InstantaneousIndex<T>> enteriesTobeRemoved = new ArrayList<InstantaneousIndex<T>>();
            for (InstantaneousIndex<T> instantaneousIndex : this._mainIndex) {
                long windowStartTime = currentTime - (long)this._observationInterval;
                if (windowStartTime <= 0L || instantaneousIndex.getClockTime() >= windowStartTime) break;
                enteriesTobeRemoved.add(instantaneousIndex);
            }
            for (InstantaneousIndex<Object> instantaneousIndex : enteriesTobeRemoved) {
                this._mainIndex.remove(instantaneousIndex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        Clock.StopClock();
    }
}

