/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.DataStructures.RedBlackNode;
import java.util.Iterator;
import java.util.Stack;

public class RedBlackEnumerator
implements Iterator {
    private Stack stack;
    private boolean ascending;
    private Comparable ordKey;
    private Object objValue;
    private RedBlackNode _sentinelNode;

    public RedBlackEnumerator() {
    }

    public RedBlackEnumerator(RedBlackNode tnode, boolean ascending, RedBlackNode sentinelNode) {
        this.stack = new Stack();
        this.ascending = ascending;
        this._sentinelNode = sentinelNode;
        if (ascending) {
            while (tnode != this._sentinelNode) {
                this.stack.push(tnode);
                tnode = tnode.getLeft();
            }
        } else {
            while (tnode != this._sentinelNode) {
                this.stack.push(tnode);
                tnode = tnode.getRight();
            }
        }
    }

    public Object getKey() {
        return this.ordKey;
    }

    public Object getValue() {
        return this.objValue;
    }

    @Override
    public boolean hasNext() {
        if (this.HasMoreElements()) {
            try {
                this.NextElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public Object next() {
        return this.objValue;
    }

    public boolean MoveNext() {
        if (this.HasMoreElements()) {
            try {
                this.NextElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
    }

    private Object getCurrent() {
        return null;
    }

    private void Reset() {
    }

    public final boolean HasMoreElements() {
        boolean result = this.stack != null && this.stack.size() > 0;
        return result;
    }

    public final Object NextElement() throws RedBlackException {
        if (this.stack.empty()) {
            throw new RedBlackException("Element not found");
        }
        RedBlackNode node = (RedBlackNode)this.stack.peek();
        if (this.ascending) {
            if (node.getRight() == this._sentinelNode) {
                RedBlackNode tn = (RedBlackNode)this.stack.pop();
                while (this.HasMoreElements() && ((RedBlackNode)this.stack.peek()).getRight() == tn) {
                    tn = (RedBlackNode)this.stack.pop();
                }
            } else {
                for (RedBlackNode tn = node.getRight(); tn != this._sentinelNode; tn = tn.getLeft()) {
                    this.stack.push(tn);
                }
            }
        } else if (node.getLeft() == this._sentinelNode) {
            RedBlackNode tn = (RedBlackNode)this.stack.pop();
            while (this.HasMoreElements() && ((RedBlackNode)this.stack.peek()).getLeft() == tn) {
                tn = (RedBlackNode)this.stack.pop();
            }
        } else {
            for (RedBlackNode tn = node.getLeft(); tn != this._sentinelNode; tn = tn.getRight()) {
                this.stack.push(tn);
            }
        }
        this.ordKey = node.getKey();
        this.objValue = node.getData();
        return node.getKey();
    }
}

