/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import Alachisoft.NCache.Common.DataStructures.ColumnType;
import Alachisoft.NCache.Common.DataStructures.RecordColumn;
import Alachisoft.NCache.Common.Enum.AggregateFunctionType;
import com.alachisoft.ncache.runtime.queries.AverageResult;
import com.alachisoft.ncache.runtime.util.JvDateFormatter;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RecordSet
implements ICompactSerializable {
    private int _rowCount = 0;
    private int _hiddenColumnCount = 0;
    private HashMap<Integer, RecordColumn> _dataIntIndex = new HashMap();
    private HashMap<String, RecordColumn> _dataStringIndex = new HashMap();

    public static ColumnDataType ToColumnDataType(Object obj) {
        if (obj instanceof String) {
            return ColumnDataType.String;
        }
        if (obj instanceof BigDecimal) {
            return ColumnDataType.Decimal;
        }
        if (obj instanceof Short) {
            return ColumnDataType.Int16;
        }
        if (obj instanceof Integer) {
            return ColumnDataType.Int32;
        }
        if (obj instanceof Long) {
            return ColumnDataType.Int64;
        }
        if (obj instanceof Short) {
            return ColumnDataType.UInt16;
        }
        if (obj instanceof Integer) {
            return ColumnDataType.UInt32;
        }
        if (obj instanceof Long) {
            return ColumnDataType.UInt64;
        }
        if (obj instanceof Double) {
            return ColumnDataType.Double;
        }
        if (obj instanceof Float) {
            return ColumnDataType.Float;
        }
        if (obj instanceof Byte) {
            return ColumnDataType.Byte;
        }
        if (obj instanceof Byte) {
            return ColumnDataType.SByte;
        }
        if (obj instanceof Boolean) {
            return ColumnDataType.Bool;
        }
        if (obj instanceof Character) {
            return ColumnDataType.Char;
        }
        if (obj instanceof Date) {
            return ColumnDataType.DateTime;
        }
        if (obj instanceof AverageResult) {
            return ColumnDataType.AverageResult;
        }
        return ColumnDataType.Object;
    }

    public static Object ToObject(String stringValue, ColumnDataType dataType) {
        switch (dataType) {
            case Bool: {
                return Boolean.parseBoolean(stringValue);
            }
            case Byte: {
                return Byte.parseByte(stringValue);
            }
            case Char: {
                return Character.valueOf(stringValue.charAt(0));
            }
            case DateTime: {
                try {
                    JvDateFormatter formatter = new JvDateFormatter("dd/MM/yyyy/HH/mm/ss/SSSS/ZZZZ");
                    formatter.parse(stringValue);
                    return formatter.getCalendar().getTime();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            case Decimal: {
                return new BigDecimal(stringValue);
            }
            case Double: {
                return Double.parseDouble(stringValue);
            }
            case Float: {
                return Float.valueOf(Float.parseFloat(stringValue));
            }
            case Int16: {
                return Short.parseShort(stringValue);
            }
            case Int32: {
                return Integer.parseInt(stringValue);
            }
            case Int64: {
                return Long.parseLong(stringValue);
            }
            case SByte: {
                return Byte.parseByte(stringValue);
            }
            case String: {
                return stringValue;
            }
            case UInt16: {
                return Short.valueOf(stringValue);
            }
            case UInt32: {
                return Integer.valueOf(stringValue);
            }
            case UInt64: {
                return Long.valueOf(stringValue);
            }
        }
        throw new ClassCastException();
    }

    public static String GetString(Object obj, ColumnDataType dataType) {
        if (dataType == ColumnDataType.DateTime) {
            JvDateFormatter formatter = new JvDateFormatter("dd/MM/yyyy/HH/mm/ss/SSSS/ZZZZ");
            String str = formatter.format((Date)obj);
            return str;
        }
        return obj.toString();
    }

    public final HashMap<Integer, RecordColumn> getData() {
        return this._dataIntIndex;
    }

    public final void Add(Object value, int rowID, int columnID) {
        if (this._rowCount <= rowID) {
            throw new IllegalArgumentException("Invalid rowID. No of rows in RecordSet are less than specified rowID.");
        }
        if (this.getColumnCount() <= columnID) {
            throw new IllegalArgumentException("Invalid columnID. No of columns in RecordSet are less than specified columnID.");
        }
        this._dataIntIndex.get(columnID).Add(value, rowID);
    }

    public final void Add(Object value, int rowID, String columnName) {
        if (this._rowCount <= rowID) {
            throw new IllegalArgumentException("Invalid rowID. No of rows in RecordSet are less than specified rowID.");
        }
        if (!this._dataStringIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
        }
        this._dataStringIndex.get(columnName).Add(value, rowID);
    }

    public final void AddRow() {
        ++this._rowCount;
    }

    public final boolean AddColumn(String columnName, boolean isHidden) {
        return this.AddColumn(columnName, isHidden, ColumnType.AttributeColumn, AggregateFunctionType.NOTAPPLICABLE);
    }

    public final boolean AddColumn(String columnName, boolean isHidden, AggregateFunctionType aggregateFunctionType) {
        return this.AddColumn(columnName, isHidden, ColumnType.AttributeColumn, aggregateFunctionType);
    }

    public final boolean AddColumn(String columnName, boolean isHidden, ColumnType columnType, AggregateFunctionType aggregateFunctionType) {
        if (this._dataStringIndex.containsKey(columnName)) {
            return false;
        }
        RecordColumn column = new RecordColumn(columnName, isHidden);
        column.setType(columnType);
        column.setAggregateFunctionType(aggregateFunctionType);
        this._dataIntIndex.put(this.getColumnCount(), column);
        this._dataStringIndex.put(columnName, column);
        if (isHidden) {
            ++this._hiddenColumnCount;
        }
        return true;
    }

    public final Object GetObject(int rowID, int columnID) {
        if (this._rowCount <= rowID) {
            throw new IllegalArgumentException("Invalid rowID. No of rows in RecordSet are less than specified rowID.");
        }
        if (this.getColumnCount() <= columnID) {
            throw new IllegalArgumentException("Invalid columnID. No of columns in RecordSet are less than specified columnID.");
        }
        return this._dataIntIndex.get(columnID).Get(rowID);
    }

    public final Object GetObject(int rowID, String columnName) {
        if (this._rowCount <= rowID) {
            throw new IllegalArgumentException("Invalid rowID. No of rows in RecordSet are less than specified rowID.");
        }
        if (!this._dataStringIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
        }
        return this._dataStringIndex.get(columnName).Get(rowID);
    }

    public final String GetColumnName(int columnID) {
        if (this.getColumnCount() <= columnID) {
            throw new IllegalArgumentException("Invalid columnID. No of columns in RecordSet are less than specified columnID.");
        }
        return this._dataIntIndex.get(columnID).getName();
    }

    public final int GetColumnIndex(String columnName) {
        if (!this._dataStringIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Invalid column name. Specified column does not exist in RecordSet.");
        }
        for (int i = 0; i < this._dataIntIndex.size(); ++i) {
            if (this._dataIntIndex.get(i).getName() != columnName) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid column name. Specified column does not exist in RecordSet.");
    }

    public final void HideColumn(String columnName) {
        if (this._dataStringIndex.containsKey(columnName)) {
            if (this._dataStringIndex.get(columnName).getIsHidden()) {
                return;
            }
            this._dataStringIndex.get(columnName).setIsHidden(true);
            ++this._hiddenColumnCount;
        }
    }

    public final void UnHideColumn(String columnName) {
        if (this._dataStringIndex.containsKey(columnName)) {
            if (!this._dataStringIndex.get(columnName).getIsHidden()) {
                return;
            }
            this._dataStringIndex.get(columnName).setIsHidden(false);
            --this._hiddenColumnCount;
        } else {
            throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
        }
    }

    public final boolean GetIsHiddenColumn(int columnID) {
        if (this.getColumnCount() <= columnID) {
            throw new IllegalArgumentException("Invalid columnID. No of columns in RecordSet are less than specified columnID.");
        }
        return this._dataIntIndex.get(columnID).getIsHidden();
    }

    public final boolean GetIsHiddenColumn(String columnName) {
        if (this._dataStringIndex.containsKey(columnName)) {
            return this._dataStringIndex.get(columnName).getIsHidden();
        }
        throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
    }

    public final void SetColumnDataType(String columnName, ColumnDataType dataType) {
        if (!this._dataStringIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
        }
        this._dataStringIndex.get(columnName).setDataType(dataType);
    }

    public final void SetColumnDataType(int index, ColumnDataType dataType) {
        if (!this._dataIntIndex.containsKey(index)) {
            throw new IllegalArgumentException("Invalid column index. Specified column does not exist in RecordSet.");
        }
        this._dataIntIndex.get(index).setDataType(dataType);
    }

    public final ColumnDataType GetColumnDataType(String columnName) {
        if (this._dataStringIndex.containsKey(columnName)) {
            return this._dataStringIndex.get(columnName).getDataType();
        }
        throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
    }

    public final ColumnDataType GetColumnDataType(int index) {
        if (this._dataIntIndex.containsKey(index)) {
            return this._dataIntIndex.get(index).getDataType();
        }
        throw new IllegalArgumentException("Invalid column index. Specified column does not exist in RecordSet.");
    }

    public final void SetAggregateFunctionType(String columnName, AggregateFunctionType type) {
        this._dataStringIndex.get(columnName).setAggregateFunctionType(type);
    }

    public final AggregateFunctionType GetAggregateFunctionType(String columnName) {
        return this._dataStringIndex.get(columnName).getAggregateFunctionType();
    }

    public final void RemoveLastColumn() {
        this._dataStringIndex.remove(this.GetColumnName(this.getColumnCount() - 1));
        if (this._dataIntIndex.get(this._dataIntIndex.size() - 1).getIsHidden()) {
            --this._hiddenColumnCount;
        }
        this._dataIntIndex.remove(this._dataIntIndex.size() - 1);
    }

    public final int getRowCount() {
        return this._rowCount;
    }

    public final int getColumnCount() {
        return this._dataStringIndex.size();
    }

    public final int getHiddenColumnCount() {
        return this._hiddenColumnCount;
    }

    public final int getColumnIndex(String columnName) {
        if (!this._dataStringIndex.containsKey(columnName)) {
            throw new IllegalArgumentException("Invalid column name. Specified column does not exist in RecordSet.");
        }
        for (int i = 0; i < this._dataIntIndex.size(); ++i) {
            if (!this._dataIntIndex.get(i).getName().equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid column name. Specified column does not exist in RecordSet.");
    }

    public final void Union(RecordSet recordSet) {
        if (this.getColumnCount() != recordSet.getColumnCount()) {
            throw new UnsupportedOperationException("Cannot compute union of two RecordSet with different number of columns.");
        }
        int thisRowCount = this._rowCount;
        for (int i = 0; i < recordSet.getRowCount(); ++i) {
            boolean recordMatch = false;
            for (int l = 0; l < thisRowCount; ++l) {
                boolean rowMatch = true;
                ArrayList<String> aggregateColumns = new ArrayList<String>();
                for (Map.Entry<String, RecordColumn> kvp : this._dataStringIndex.entrySet()) {
                    if (kvp.getValue().getType() == ColumnType.AggregateResultColumn) {
                        aggregateColumns.add(kvp.getKey());
                        continue;
                    }
                    if (recordSet.GetObject(i, kvp.getKey()).equals(this.GetObject(l, kvp.getKey()))) continue;
                    rowMatch = false;
                    break;
                }
                if (!rowMatch) continue;
                for (String column : aggregateColumns) {
                    switch (this.GetAggregateFunctionType(column)) {
                        case SUM: {
                            BigDecimal a = new BigDecimal(0);
                            BigDecimal b = new BigDecimal(0);
                            Object thisVal = this.GetObject(i, column);
                            Object otherVal = recordSet.GetObject(i, column);
                            BigDecimal sum = null;
                            if (thisVal == null && otherVal != null) {
                                sum = (BigDecimal)otherVal;
                            } else if (thisVal != null && otherVal == null) {
                                sum = (BigDecimal)thisVal;
                            } else if (thisVal != null && otherVal != null) {
                                a = (BigDecimal)thisVal;
                                b = (BigDecimal)otherVal;
                                sum = a.add(b);
                            }
                            if (sum != null) {
                                this.Add((Object)sum, i, column);
                                break;
                            }
                            this.Add(null, i, column);
                            break;
                        }
                        case COUNT: {
                            BigDecimal a = (BigDecimal)this.GetObject(i, column);
                            BigDecimal b = (BigDecimal)recordSet.GetObject(i, column);
                            BigDecimal count = a.add(b);
                            this.Add((Object)count, i, column);
                            break;
                        }
                        case MIN: {
                            Comparable thisValue = (Comparable)this.GetObject(i, column);
                            Comparable otherValue = (Comparable)recordSet.GetObject(i, column);
                            Comparable min = thisValue;
                            if (thisValue == null && otherValue != null) {
                                min = otherValue;
                            } else if (thisValue != null && otherValue == null) {
                                min = thisValue;
                            } else if (thisValue == null && otherValue == null) {
                                min = null;
                            } else if (otherValue.compareTo(thisValue) < 0) {
                                min = otherValue;
                            }
                            this.Add((Object)min, i, column);
                            break;
                        }
                        case MAX: {
                            Comparable thisValue = (Comparable)this.GetObject(i, column);
                            Comparable otherValue = (Comparable)recordSet.GetObject(i, column);
                            Comparable max = thisValue;
                            if (thisValue == null && otherValue != null) {
                                max = otherValue;
                            } else if (thisValue != null && otherValue == null) {
                                max = thisValue;
                            } else if (thisValue == null && otherValue == null) {
                                max = null;
                            } else if (otherValue.compareTo(thisValue) > 0) {
                                max = otherValue;
                            }
                            this.Add((Object)max, i, column);
                            break;
                        }
                        case AVG: {
                            Object thisVal = this.GetObject(i, column);
                            Object otherVal = recordSet.GetObject(i, column);
                            AverageResult avg = null;
                            if (thisVal == null && otherVal != null) {
                                avg = (AverageResult)otherVal;
                            } else if (thisVal != null && otherVal == null) {
                                avg = (AverageResult)thisVal;
                            } else if (thisVal != null && otherVal != null) {
                                AverageResult thisResult = (AverageResult)thisVal;
                                AverageResult otherResult = (AverageResult)otherVal;
                                avg = new AverageResult();
                                avg.setSum(thisResult.getSum().add(otherResult.getSum()));
                                avg.setCount(thisResult.getCount().add(otherResult.getCount()));
                            }
                            if (avg != null) {
                                this.Add((Object)avg, i, column);
                                break;
                            }
                            this.Add(null, i, column);
                        }
                    }
                }
                recordMatch = true;
                break;
            }
            if (recordMatch) continue;
            this.AddRow();
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.Add(recordSet.GetObject(i, j), this._rowCount - 1, j);
            }
        }
    }

    public void serialize(NCacheObjectOutput out) throws IOException {
        out.write(this._rowCount);
        for (Map.Entry<String, RecordColumn> kvp : this._dataStringIndex.entrySet()) {
            out.writeObject((Object)kvp.getKey());
            out.writeObject((Object)kvp.getValue());
        }
    }

    public void deserialize(NCacheObjectInput in) throws IOException, ClassNotFoundException {
        this._rowCount = in.readInt();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Object tempVar = in.readObject();
            String key = (String)(tempVar instanceof String ? tempVar : null);
            Object tempVar2 = in.readObject();
            RecordColumn col = (RecordColumn)(tempVar2 instanceof RecordColumn ? tempVar2 : null);
            this._dataStringIndex.put(key, col);
            this._dataIntIndex.put(i, col);
        }
    }
}

