/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import Alachisoft.NCache.Common.DataStructures.ColumnType;
import Alachisoft.NCache.Common.Enum.AggregateFunctionType;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RecordColumn
implements ICompactSerializable {
    private String _name;
    private boolean _isHidden;
    private ColumnType _columnType = ColumnType.AttributeColumn;
    private ColumnDataType _dataType = ColumnDataType.Object;
    private AggregateFunctionType _aggregateFunctionType;
    private HashMap<Integer, Object> _data;

    public RecordColumn(String name, boolean isHidden) {
        this.getAggregateFunctionType();
        this._aggregateFunctionType = AggregateFunctionType.NOTAPPLICABLE;
        this._name = name;
        this._isHidden = isHidden;
        this._data = new HashMap();
    }

    public final HashMap<Integer, Object> getData() {
        return this._data;
    }

    public final String getName() {
        return this._name;
    }

    public final boolean getIsHidden() {
        return this._isHidden;
    }

    public final void setIsHidden(boolean value) {
        this._isHidden = value;
    }

    public final ColumnType getType() {
        return this._columnType;
    }

    public final void setType(ColumnType value) {
        this._columnType = value;
    }

    public final ColumnDataType getDataType() {
        return this._dataType;
    }

    public final void setDataType(ColumnDataType value) {
        this._dataType = value;
    }

    public final AggregateFunctionType getAggregateFunctionType() {
        return this._aggregateFunctionType;
    }

    public final void setAggregateFunctionType(AggregateFunctionType value) {
        this._aggregateFunctionType = value;
    }

    public final void Add(Object value, int rowID) {
        this._data.put(rowID, value);
    }

    public final Object Get(int rowID) {
        return this._data.get(rowID);
    }

    public void serialize(NCacheObjectOutput out) throws IOException {
        out.writeObject((Object)this._name);
        out.writeBoolean(this._isHidden);
        out.write(this._columnType.getValue());
        out.write(this._data.size());
        for (Map.Entry<Integer, Object> de : this._data.entrySet()) {
            out.write(de.getKey().intValue());
            out.writeObject(de.getValue());
        }
    }

    public void deserialize(NCacheObjectInput in) throws IOException, ClassNotFoundException {
        Object tempVar = in.readObject();
        this._name = (String)(tempVar instanceof String ? tempVar : null);
        this._isHidden = in.readBoolean();
        this._columnType = ColumnType.forValue(in.readInt());
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this._data.put(in.readInt(), in.readObject());
        }
    }
}

