/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import Alachisoft.NCache.Common.DataStructures.KeyValuesContainer;
import Alachisoft.NCache.Common.DataStructures.RecordSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class MultiRootTree {
    private String _currentAttribute;
    private ArrayList<String> _attributeNames;
    private Hashtable _ht = new Hashtable();
    private int _levels;

    public MultiRootTree(int levels, ArrayList<String> attributeNames) {
        this._levels = levels;
        this._attributeNames = attributeNames;
        this._currentAttribute = attributeNames.get(attributeNames.size() - this._levels);
    }

    public final int getLevels() {
        return this._levels;
    }

    public final void Add(KeyValuesContainer value) {
        if (this._levels == 1) {
            if (this._ht.get(value.getValues().get(this._currentAttribute)) instanceof ArrayList) {
                ((ArrayList)this._ht.get(value.getValues().get(this._currentAttribute))).add(value.getKey());
            } else {
                ArrayList<String> al = new ArrayList<String>();
                al.add(value.getKey());
                this._ht.put(value.getValues().get(this._currentAttribute), al);
            }
        } else if (this._ht.get(value.getValues().get(this._currentAttribute)) instanceof MultiRootTree) {
            ((MultiRootTree)this._ht.get(value.getValues().get(this._currentAttribute))).Add(value);
        } else {
            MultiRootTree mrt = new MultiRootTree(this._levels - 1, this._attributeNames);
            mrt.Add(value);
            this._ht.put(value.getValues().get(this._currentAttribute), mrt);
        }
    }

    private int GenerateRecordSet(RecordSet recordSet) {
        Iterator iterator = this._ht.entrySet().iterator();
        int rowsAdded = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof ArrayList) {
                ++rowsAdded;
                recordSet.AddRow();
                if (recordSet.GetColumnDataType(this._currentAttribute) == ColumnDataType.Object) {
                    recordSet.SetColumnDataType(this._currentAttribute, RecordSet.ToColumnDataType(entry.getKey()));
                }
                recordSet.Add(entry.getKey(), recordSet.getRowCount() - 1, this._currentAttribute);
                recordSet.Add(entry.getValue(), recordSet.getRowCount() - 1, recordSet.getColumnCount() - 1);
                continue;
            }
            rowsAdded = ((MultiRootTree)(entry.getValue() instanceof MultiRootTree ? entry.getValue() : null)).GenerateRecordSet(recordSet);
            for (int i = 0; i < rowsAdded; ++i) {
                recordSet.Add(entry.getKey(), recordSet.getRowCount() - i - 1, this._currentAttribute);
                if (recordSet.GetColumnDataType(this._currentAttribute) != ColumnDataType.Object) continue;
                recordSet.SetColumnDataType(this._currentAttribute, RecordSet.ToColumnDataType(entry.getKey()));
            }
        }
        return rowsAdded;
    }

    public final void ToRecordSet(RecordSet recordSet) {
        recordSet.AddColumn("", true);
        this.GenerateRecordSet(recordSet);
    }
}

