/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.BucketStatus;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;

public class HashMapBucket
implements ICompactSerializable,
Cloneable {
    private int _bucketId;
    private Address _tempAddress;
    private Address _permanentAddress;
    private Latch _stateTxfrLatch = new Latch(4);
    private Object _status_wait_mutex = new Object();

    public HashMapBucket(Address address, int id) {
        this._tempAddress = this._permanentAddress = address;
        this._bucketId = id;
        this._stateTxfrLatch = new Latch(4);
    }

    public HashMapBucket(Address address, int id, byte status) {
        this(address, id);
        this.setStatus(status);
    }

    @Deprecated
    public HashMapBucket() {
    }

    public final int getBucketId() {
        return this._bucketId;
    }

    public final Address getTempAddress() {
        return this._tempAddress;
    }

    public final void setTempAddress(Address value) {
        this._tempAddress = value;
    }

    public final Address getPermanentAddress() {
        return this._permanentAddress;
    }

    public final void setPermanentAddress(Address value) {
        this._permanentAddress = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void WaitForStatus(Address tmpOwner, byte status) throws InterruptedException {
        if (tmpOwner != null) {
            while (tmpOwner == this._tempAddress) {
                if (this._stateTxfrLatch.IsAnyBitsSet(status)) {
                    return;
                }
                Object object = this._status_wait_mutex;
                synchronized (object) {
                    if (tmpOwner == this._tempAddress || this._stateTxfrLatch.IsAnyBitsSet(status)) {
                        return;
                    }
                    Monitor.wait(this._status_wait_mutex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void NotifyBucketUpdate() {
        Object object = this._status_wait_mutex;
        synchronized (object) {
            Monitor.pulse(this._status_wait_mutex);
        }
    }

    public final byte getStatus() {
        return this._stateTxfrLatch.getStatus().getData();
    }

    public final void setStatus(byte value) {
        switch (value) {
            case 1: 
            case 2: 
            case 4: {
                byte oldStatus = this._stateTxfrLatch.getStatus().getData();
                if (oldStatus == value) {
                    return;
                }
                this._stateTxfrLatch.SetStatusBit(value, oldStatus);
            }
        }
    }

    public final Latch getStateTxfrLatch() {
        return this._stateTxfrLatch;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashMapBucket) {
            return this.getBucketId() == ((HashMapBucket)obj).getBucketId();
        }
        return false;
    }

    public final Object clone() {
        HashMapBucket hmBucket = new HashMapBucket(this._permanentAddress, this._bucketId);
        hmBucket.setTempAddress(this._tempAddress);
        hmBucket.setStatus(this.getStatus());
        return hmBucket;
    }

    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._bucketId = reader.readInt();
        this._tempAddress = (Address)reader.readObject();
        this._permanentAddress = (Address)reader.readObject();
        byte status = reader.readByte();
        this._stateTxfrLatch = new Latch(status);
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeInt(this._bucketId);
        writer.writeObject((Object)this._tempAddress);
        writer.writeObject((Object)this._permanentAddress);
        writer.writeByte((int)this._stateTxfrLatch.getStatus().getData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bucket[" + this._bucketId + " ; ");
        sb.append("owner = " + this._permanentAddress + " ; ");
        sb.append("temp = " + this._tempAddress + " ; ");
        String status = BucketStatus.StatusToString(this._stateTxfrLatch.getStatus().getData());
        sb.append(status + " ]");
        return sb.toString();
    }
}

