/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.IPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class BinaryPriorityQueue
implements IPriorityQueue,
Cloneable {
    protected ArrayList InnerList = new ArrayList();
    protected Comparator Comparer;
    boolean isSynch = false;

    public BinaryPriorityQueue() {
        this(null);
    }

    public BinaryPriorityQueue(Comparator c) {
        this.Comparer = c;
    }

    public BinaryPriorityQueue(int C) {
        this(null, C);
    }

    public BinaryPriorityQueue(Comparator c, int Capacity) {
        this.Comparer = c;
        this.InnerList.ensureCapacity(Capacity);
    }

    protected BinaryPriorityQueue(ArrayList Core, Comparator Comp, boolean Copy) {
        Object tempVar = null;
        this.InnerList = Copy ? (ArrayList)((tempVar = Core.clone()) instanceof ArrayList ? tempVar : null) : Core;
        this.Comparer = Comp;
    }

    public static BinaryPriorityQueue Syncronized(BinaryPriorityQueue P) {
        P.isSynch = true;
        return new BinaryPriorityQueue((ArrayList)Collections.synchronizedList(P.InnerList), P.Comparer, false);
    }

    public static BinaryPriorityQueue ReadOnly(BinaryPriorityQueue P) {
        return new BinaryPriorityQueue((ArrayList)Collections.unmodifiableCollection(P.InnerList), P.Comparer, false);
    }

    protected final void SwitchElements(int i, int j) {
        Object h = this.InnerList.get(i);
        this.InnerList.set(i, this.InnerList.get(j));
        this.InnerList.set(j, h);
    }

    protected int OnCompare(int i, int j) {
        return this.Comparer.compare(this.InnerList.get(i), this.InnerList.get(j));
    }

    @Override
    public int push(Object O) {
        int p2;
        int p = this.InnerList.size();
        this.InnerList.add(O);
        while (p != 0 && this.OnCompare(p, p2 = (p - 1) / 2) < 0) {
            this.SwitchElements(p, p2);
            p = p2;
        }
        return p;
    }

    @Override
    public Object pop() {
        Object result = this.InnerList.get(0);
        int p = 0;
        this.InnerList.set(0, this.InnerList.get(this.InnerList.size() - 1));
        this.InnerList.remove(this.InnerList.size() - 1);
        while (true) {
            int pn = p;
            int p1 = 2 * p + 1;
            int p2 = 2 * p + 2;
            if (this.InnerList.size() > p1 && this.OnCompare(p, p1) > 0) {
                p = p1;
            }
            if (this.InnerList.size() > p2 && this.OnCompare(p, p2) > 0) {
                p = p2;
            }
            if (p == pn) break;
            this.SwitchElements(p, pn);
        }
        return result;
    }

    @Override
    public void update(int i) {
        int p2;
        int p = i;
        while (p != 0 && this.OnCompare(p, p2 = (p - 1) / 2) < 0) {
            this.SwitchElements(p, p2);
            p = p2;
        }
        if (p < i) {
            return;
        }
        while (true) {
            int pn = p;
            int p1 = 2 * p + 1;
            p2 = 2 * p + 2;
            if (this.InnerList.size() > p1 && this.OnCompare(p, p1) > 0) {
                p = p1;
            }
            if (this.InnerList.size() > p2 && this.OnCompare(p, p2) > 0) {
                p = p2;
            }
            if (p == pn) break;
            this.SwitchElements(p, pn);
        }
    }

    @Override
    public Object peek() {
        if (this.InnerList.size() > 0) {
            return this.InnerList.get(0);
        }
        return null;
    }

    public boolean Contains(Object value) {
        return this.InnerList.contains(value);
    }

    public void Clear() {
        this.InnerList.clear();
    }

    public int getCount() {
        return this.InnerList.size();
    }

    private Iterator GetEnumerator() {
        return this.InnerList.iterator();
    }

    public final void CopyTo(Object[] array, int index) {
        for (int i = 0; i < index; ++i) {
            this.InnerList.add(index + i, array[i]);
        }
    }

    public final Object clone() {
        return new BinaryPriorityQueue(this.InnerList, this.Comparer, true);
    }

    public final boolean getIsSynchronized() {
        return this.isSynch;
    }

    public final Object getSyncRoot() {
        return this;
    }

    private boolean getIsReadOnly() {
        return false;
    }

    private Object getItem(int index) {
        return this.InnerList.get(index);
    }

    private void setItem(int index, Object value) {
        this.InnerList.set(index, value);
        this.update(index);
    }

    private int Add(Object o) {
        return this.push(o);
    }

    private boolean getIsFixedSize() {
        return false;
    }
}

