/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataReader;

import Alachisoft.NCache.Common.DataReader.ColumnCollection;
import Alachisoft.NCache.Common.DataReader.TwoDimensionalArray;
import Alachisoft.NCache.Common.DataStructures.ColumnType;
import Alachisoft.NCache.Common.Queries.AverageResult;
import Alachisoft.NCache.Common.Queries.Order;
import Alachisoft.NCache.Common.Queries.OrderByArgument;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class RecordRow
implements Cloneable,
InternalCompactSerializable {
    public boolean isSurrogate;
    private ColumnCollection _columns;
    private TwoDimensionalArray _objects;
    private Object _tag;

    public RecordRow(ColumnCollection columns) {
        this._columns = columns;
        this._objects = new TwoDimensionalArray(columns.getCount());
    }

    public final Object get(int index) {
        return this._objects.get(index);
    }

    public final void set(int index, Object value) {
        this._objects.set(index, value);
    }

    public final Object get(String columnName) {
        return this._objects.get(this._columns.getColumnIndex(columnName));
    }

    public final void set(String columnName, Object value) {
        this._objects.set(this._columns.getColumnIndex(columnName), value);
    }

    public final Object getTag() {
        return this._tag;
    }

    public final void setTag(Object value) {
        this._tag = value;
    }

    public final ColumnCollection getColumns() {
        return this._columns;
    }

    public final void setColumns(ColumnCollection value) {
        this._columns = value;
    }

    public final void setColumnValue(String columnName, Object value) {
        this._objects.set(this._columns.getColumnIndex(columnName), value);
    }

    public final void setColumnValue(int columnIndex, Object value) {
        this._objects.set(columnIndex, value);
    }

    public final Object getColumnValue(String columnName) {
        return this._objects.get(this._columns.getColumnIndex(columnName));
    }

    public final Object getColumnValue(int columnIndex) {
        return this._objects.get(columnIndex);
    }

    public final Object[] getAll() {
        return (Object[])this._objects.clone();
    }

    public final void setAll(ArrayList values) {
        System.arraycopy(values, 0, this._objects, 0, values.size());
    }

    public final int getSize() {
        int size = 0;
        block19: for (int i = 0; i < this._columns.getCount(); ++i) {
            switch (this._columns.get(i).getDataType()) {
                case AverageResult: {
                    size += 32;
                    continue block19;
                }
                case Bool: {
                    ++size;
                    continue block19;
                }
                case Byte: {
                    ++size;
                    continue block19;
                }
                case Char: {
                    size += 2;
                    continue block19;
                }
                case DateTime: {
                    size += 64;
                    continue block19;
                }
                case Decimal: {
                    size += 16;
                    continue block19;
                }
                case Double: {
                    size += 8;
                    continue block19;
                }
                case Float: {
                    size += 4;
                    continue block19;
                }
                case Int16: {
                    size += 2;
                    continue block19;
                }
                case Int32: {
                    size += 4;
                    continue block19;
                }
                case Int64: {
                    size += 8;
                    continue block19;
                }
                case Object: {
                    continue block19;
                }
                case SByte: {
                    ++size;
                    continue block19;
                }
                case String: {
                    String obj;
                    String string = obj = this._objects.get(i) instanceof String ? (String)this._objects.get(i) : null;
                    if (obj == null) continue block19;
                    size += obj.length() * 2;
                    continue block19;
                }
                case UInt16: {
                    size += 2;
                    continue block19;
                }
                case UInt32: {
                    size += 4;
                    continue block19;
                }
                case UInt64: {
                    size += 8;
                }
            }
        }
        return size;
    }

    public Object clone() {
        RecordRow row = new RecordRow(this._columns);
        row._objects = (TwoDimensionalArray)this._objects.clone();
        return row;
    }

    public final int compareOrder(RecordRow row, ArrayList<OrderByArgument> orderBy) {
        int result = 0;
        for (OrderByArgument oba : orderBy) {
            Object columValue = this.getColumnValue(oba.getAttributeName());
            Object rowValue = row.getColumnValue(oba.getAttributeName());
            switch (this._columns.get(oba.getAttributeName()).getDataType()) {
                case Bool: {
                    result = ((Boolean)columValue).compareTo((Boolean)rowValue);
                    break;
                }
                case Byte: 
                case SByte: {
                    result = Byte.compare((Byte)columValue, (Byte)rowValue);
                    break;
                }
                case Char: {
                    Character c1 = Character.valueOf(((Character)columValue).charValue());
                    Character c2 = Character.valueOf(((Character)rowValue).charValue());
                    result = c1.compareTo(c2);
                    break;
                }
                case DateTime: {
                    result = ((Date)columValue).compareTo((Date)rowValue);
                    break;
                }
                case Decimal: {
                    result = ((BigDecimal)columValue).compareTo((BigDecimal)rowValue);
                    break;
                }
                case Double: {
                    result = ((Double)columValue).compareTo((Double)rowValue);
                    break;
                }
                case Float: {
                    result = ((Float)columValue).compareTo((Float)rowValue);
                    break;
                }
                case Int16: 
                case UInt16: {
                    result = Short.compare((Short)columValue, (Short)rowValue);
                    break;
                }
                case Int32: 
                case UInt32: {
                    result = ((Integer)columValue).compareTo((Integer)rowValue);
                    break;
                }
                case Int64: 
                case UInt64: {
                    result = ((Long)columValue).compareTo((Long)rowValue);
                    break;
                }
                case String: {
                    result = this.compareString((String)columValue, (String)rowValue);
                }
            }
            if (result == 0) continue;
            if (oba.getOrder() != Order.DESC) break;
            result = -result;
            break;
        }
        return result;
    }

    public final void merge(RecordRow row) {
        block8: for (int i = 0; i < this._columns.getCount(); ++i) {
            if (this._columns.get(i).getColumnType() != ColumnType.AggregateResultColumn) continue;
            switch (this._columns.get(i).getAggregateFunctionType()) {
                case SUM: {
                    BigDecimal b;
                    BigDecimal a;
                    Object thisVal = this._objects.get(i);
                    Object otherVal = row._objects.get(i);
                    BigDecimal sum = null;
                    if (thisVal == null && otherVal != null) {
                        sum = (BigDecimal)otherVal;
                    } else if (thisVal != null && otherVal == null) {
                        sum = (BigDecimal)thisVal;
                    } else if (thisVal != null && otherVal != null) {
                        a = (BigDecimal)thisVal;
                        b = (BigDecimal)otherVal;
                        sum = a.add(b);
                    }
                    if (sum != null) {
                        this._objects.set(i, sum);
                        continue block8;
                    }
                    this._objects.set(i, null);
                    continue block8;
                }
                case COUNT: {
                    BigDecimal a = (BigDecimal)this._objects.get(i);
                    BigDecimal b = (BigDecimal)row._objects.get(i);
                    BigDecimal count = a.add(b);
                    this._objects.set(i, count);
                    continue block8;
                }
                case MIN: {
                    Comparable thisValue = (Comparable)this._objects.get(i);
                    Comparable otherValue = (Comparable)row._objects.get(i);
                    Comparable min = thisValue;
                    if (thisValue == null && otherValue != null) {
                        min = otherValue;
                    } else if (thisValue != null && otherValue == null) {
                        min = thisValue;
                    } else if (thisValue == null && otherValue == null) {
                        min = null;
                    } else if (otherValue.compareTo(thisValue) < 0) {
                        min = otherValue;
                    }
                    this._objects.set(i, min);
                    continue block8;
                }
                case MAX: {
                    Comparable thisValue = (Comparable)this._objects.get(i);
                    Comparable otherValue = (Comparable)row._objects.get(i);
                    Comparable max = thisValue;
                    if (thisValue == null && otherValue != null) {
                        max = otherValue;
                    } else if (thisValue != null && otherValue == null) {
                        max = thisValue;
                    } else if (thisValue == null && otherValue == null) {
                        max = null;
                    } else if (otherValue.compareTo(thisValue) > 0) {
                        max = otherValue;
                    }
                    this._objects.set(i, max);
                    continue block8;
                }
                case AVG: {
                    Object thisVal = this._objects.get(i);
                    Object otherVal = row._objects.get(i);
                    AverageResult avg = null;
                    if (thisVal == null && otherVal != null) {
                        avg = (AverageResult)otherVal;
                    } else if (thisVal != null && otherVal == null) {
                        avg = (AverageResult)thisVal;
                    } else if (thisVal != null && otherVal != null) {
                        AverageResult thisResult = (AverageResult)thisVal;
                        AverageResult otherResult = (AverageResult)otherVal;
                        avg = new AverageResult();
                        avg.setSum(thisResult.getSum().add(otherResult.getSum()));
                        avg.setCount(thisResult.getCount().add(otherResult.getCount()));
                    }
                    this._objects.set(i, avg);
                    continue block8;
                }
                case TERMFREQ: {
                    Object thisVal = this._objects.get(i);
                    Object otherVal = row._objects.get(i);
                    long freqSum = 0L;
                    if (thisVal == null && otherVal != null) {
                        freqSum = (Long)otherVal;
                    } else if (thisVal != null && otherVal == null) {
                        freqSum = (Long)thisVal;
                    } else if (thisVal != null && otherVal != null) {
                        freqSum = (Long)thisVal + (Long)otherVal;
                    }
                    this._objects.set(i, freqSum);
                }
            }
        }
    }

    private int compareString(String valueOne, String valueTwo) {
        int result = valueOne == null ? (valueTwo == null ? 0 : -1) : (valueTwo == null ? 1 : valueOne.compareTo(valueTwo));
        return result;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.isSurrogate = reader.ReadBoolean();
        Object tempVar = reader.ReadObject();
        this._columns = tempVar instanceof ColumnCollection ? (ColumnCollection)tempVar : null;
        this._objects = new TwoDimensionalArray(this._columns.getCount());
        for (int i = 0; i < this._objects.size(); ++i) {
            this._objects.set(i, reader.ReadObject());
        }
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this.isSurrogate);
        writer.WriteObject((Object)this._columns);
        for (int i = 0; i < this._objects.size(); ++i) {
            writer.WriteObject(this._objects.get(i));
        }
    }
}

