/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataReader;

import Alachisoft.NCache.Common.DataReader.ColumnCollection;
import Alachisoft.NCache.Common.DataReader.IPartitionInfo;
import Alachisoft.NCache.Common.DataReader.ReaderResultSet;
import Alachisoft.NCache.Common.DataReader.RecordRow;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumeratorImpl;
import Alachisoft.NCache.Common.DataReader.RecordSetLoader;
import com.alachisoft.ncache.runtime.exceptions.InvalidReaderException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.UUID;

public class PartitionRSEnumerator
implements RecordSetEnumerator,
IPartitionInfo {
    private RecordSetEnumerator _recordSetEnumerator;
    private String _nodeIP;
    private String _readerId;
    private int _nextIndex;
    private RecordSetLoader _cacheImpl;
    private boolean isValid = true;
    private int _port;
    private String uniqueId = "";

    public PartitionRSEnumerator(RecordSetEnumerator recordSetEnumerator, String readerId, String nodeIP, int nextIdex, RecordSetLoader cacheImpl) {
        this._recordSetEnumerator = recordSetEnumerator;
        this._readerId = readerId;
        this._nextIndex = nextIdex;
        this._cacheImpl = cacheImpl;
        this.uniqueId = UUID.randomUUID().toString();
        this.parseAddress(nodeIP);
    }

    @Override
    public final String getServer() {
        return this._nodeIP;
    }

    private void parseAddress(String address) {
        if (!address.isEmpty() && address != null) {
            String[] hostPort = address.split("[:]", -1);
            this._nodeIP = hostPort[0];
            if (hostPort.length > 1) {
                try {
                    this._port = Integer.parseInt(hostPort[1]);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private String getReciepent() {
        return this._port > 0 ? this._nodeIP + ":" + this._port : this._nodeIP;
    }

    public final String getReaderId() {
        return this._readerId;
    }

    public final void setIsValid(boolean value) {
        this.isValid = value;
    }

    public final boolean getNextRecordSetChunk() throws InvalidReaderException {
        ReaderResultSet readerChunk = null;
        if (this._cacheImpl != null) {
            if (!this.isValid) {
                throw new InvalidReaderException("Reader state has been lost.");
            }
            try {
                readerChunk = this._cacheImpl.getRecordSet(this._readerId, this._nextIndex, this._nodeIP, this.getReciepent());
            }
            catch (OperationFailedException e) {
                throw new InvalidReaderException("Reader state has been lost.");
            }
        }
        if (readerChunk != null && readerChunk.getRecordSet() != null && readerChunk.getRecordSet().getRowCount() > 0) {
            this._recordSetEnumerator = new RecordSetEnumeratorImpl(readerChunk.getRecordSet());
            this._nextIndex = readerChunk.getNextIndex();
            return this._recordSetEnumerator.moveNext();
        }
        return false;
    }

    @Override
    public final RecordRow getCurrent() {
        return this._recordSetEnumerator.getCurrent();
    }

    @Override
    public final ColumnCollection getColumnCollection() {
        return this._recordSetEnumerator.getColumnCollection();
    }

    @Override
    public final boolean moveNext() {
        boolean next = this._recordSetEnumerator.moveNext();
        if (!next) {
            try {
                next = this.getNextRecordSetChunk();
            }
            catch (InvalidReaderException e) {
                throw new RuntimeException(e);
            }
        }
        return next;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public boolean equals(Object obj) {
        PartitionRSEnumerator pr;
        if (obj == null) {
            return false;
        }
        PartitionRSEnumerator partitionRSEnumerator = pr = obj instanceof PartitionRSEnumerator ? (PartitionRSEnumerator)obj : null;
        if (pr == null) {
            return false;
        }
        return this.uniqueId.equals(pr.uniqueId);
    }

    @Override
    public void close() throws Exception {
        try {
            if (this._cacheImpl != null) {
                this._cacheImpl.disposeReader(this._readerId, this._nodeIP);
            }
            this._recordSetEnumerator.close();
            this._cacheImpl = null;
        }
        catch (InvalidReaderException e) {
            throw new InvalidReaderException("Reader state has been lost.");
        }
    }
}

