/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataReader;

import Alachisoft.NCache.Common.DataReader.ColumnCollection;
import Alachisoft.NCache.Common.DataReader.IPartitionInfo;
import Alachisoft.NCache.Common.DataReader.RecordRow;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import com.alachisoft.ncache.runtime.exceptions.InvalidReaderException;
import java.util.ArrayList;
import java.util.HashMap;

public class DistributedRSEnumerator
implements RecordSetEnumerator {
    protected ArrayList<RecordSetEnumerator> _partitionRecordSets = null;
    protected RecordRow _current = null;
    private RecordSetEnumerator _currentRecordSet = null;
    private int _counter = 0;
    private boolean _next = false;
    private HashMap<String, HashMap<RecordSetEnumerator, Object>> _validReaders;

    public DistributedRSEnumerator(ArrayList<RecordSetEnumerator> partitionRecordSets, HashMap<String, HashMap<RecordSetEnumerator, Object>> validReaders) {
        this._partitionRecordSets = partitionRecordSets;
        this._validReaders = validReaders;
    }

    @Override
    public final RecordRow getCurrent() {
        return this._current;
    }

    @Override
    public final ColumnCollection getColumnCollection() {
        return this._partitionRecordSets.size() > 0 ? this._partitionRecordSets.get(0).getColumnCollection() : null;
    }

    @Override
    public boolean moveNext() {
        try {
            this.setCurrentEnumerator();
        }
        catch (InvalidReaderException e) {
            throw new RuntimeException(e);
        }
        return this._next;
    }

    private void setCurrentEnumerator() throws InvalidReaderException {
        if (this._partitionRecordSets.size() == 0) {
            return;
        }
        boolean hasNext = false;
        do {
            try {
                if (this._partitionRecordSets.size() <= this._counter) {
                    throw new InvalidReaderException("Data reader has lost its state");
                }
                this._currentRecordSet = this._partitionRecordSets.get(this._counter);
                hasNext = this._currentRecordSet.moveNext();
            }
            catch (InvalidReaderException e) {
                try {
                    this.close();
                }
                catch (Exception ex) {
                    throw new InvalidReaderException("Data reader has lost its state");
                }
            }
            if (hasNext) {
                this._current = this._currentRecordSet.getCurrent();
            } else {
                this._partitionRecordSets.remove(this._currentRecordSet);
                this.removeFromValidReaders(this._currentRecordSet);
            }
            ++this._counter;
            if (this._counter < this._partitionRecordSets.size()) continue;
            this._counter = 0;
        } while (!hasNext && this._partitionRecordSets.size() > 0);
        this._next = hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromValidReaders(RecordSetEnumerator pe) {
        IPartitionInfo info;
        IPartitionInfo iPartitionInfo = info = pe instanceof IPartitionInfo ? (IPartitionInfo)((Object)pe) : null;
        if (info != null) {
            HashMap<RecordSetEnumerator, Object> readers = null;
            HashMap<String, HashMap<RecordSetEnumerator, Object>> hashMap = this._validReaders;
            synchronized (hashMap) {
                readers = this._validReaders.get(info.getServer());
                if (readers != null) {
                    readers.remove(pe);
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this._partitionRecordSets != null) {
            for (RecordSetEnumerator pe : this._partitionRecordSets) {
                pe.close();
                this.removeFromValidReaders(pe);
            }
            this._partitionRecordSets = null;
        }
    }
}

