/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.BitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionUtil {
    private static final int Compressed = 2;

    public static byte[] Compress(byte[] value, BitSet flag, long threshold) {
        if (value == null) {
            return value;
        }
        if (flag == null) {
            return value;
        }
        if ((long)value.length <= threshold) {
            return value;
        }
        try {
            return CompressionUtil.Compress(value, flag);
        }
        catch (IOException ioe) {
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }

    public static byte[] Compress(byte[] value, BitSet flag) throws IOException {
        GZIPOutputStream ZippedObject = null;
        ByteArrayOutputStream memStream = null;
        try {
            memStream = new ByteArrayOutputStream();
            ZippedObject = new GZIPOutputStream(memStream);
            ZippedObject.write(value, 0, value.length);
            if (flag == null) {
                flag = new BitSet();
            }
            flag.SetBit((byte)2);
            ZippedObject.close();
            ZippedObject.finish();
            memStream.close();
            return memStream.toByteArray();
        }
        catch (Exception ex) {
            flag.UnsetBit((byte)2);
            return value;
        }
    }

    public static byte[] Decompress(byte[] value, BitSet flag) throws Exception {
        if (value == null) {
            return value;
        }
        if (flag == null) {
            return value;
        }
        if (flag.IsBitSet((byte)2)) {
            return CompressionUtil.Decompress(value);
        }
        return value;
    }

    public static byte[] Decompress(byte[] value) throws IOException {
        int count;
        GZIPInputStream uncompressedValue = null;
        ByteArrayOutputStream result = null;
        uncompressedValue = new GZIPInputStream(new ByteArrayInputStream(value));
        result = new ByteArrayOutputStream();
        byte[] tmp = new byte[2048];
        while ((count = uncompressedValue.read(tmp, 0, tmp.length)) > 0) {
            result.write(tmp, 0, count);
        }
        result.close();
        uncompressedValue.close();
        return result.toByteArray();
    }
}

