/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Communication;

import Alachisoft.NCache.Common.Communication.Exceptions.ChannelException;
import Alachisoft.NCache.Common.Communication.Exceptions.ConnectionException;
import Alachisoft.NCache.Common.Communication.IChannel;
import Alachisoft.NCache.Common.Communication.IChannelEventListener;
import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Communication.IConnection;
import Alachisoft.NCache.Common.Communication.IResponse;
import Alachisoft.NCache.Common.Communication.ITraceProvider;
import Alachisoft.NCache.Common.Communication.TcpConnection;
import Alachisoft.NCache.Common.GenericCopier;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import tangible.DotNetToJavaStringHelper;

public class TcpChannel
implements IChannel {
    private static final int DATA_SIZE_BUFFER_LENGTH = 10;
    private IConnection _connection;
    private String _serverIP;
    private String _bindIP;
    private int _port;
    private byte[] _sizeBuffer = new byte[10];
    private IChannelFormatter _formatter;
    private IChannelEventListener _eventListener;
    private Thread _receiverThread;
    private ITraceProvider _traceProvider;
    private boolean stopThread;
    private String privateName;

    public TcpChannel(String serverIP, int port, String bindingIP, ITraceProvider traceProvider) {
        if (DotNetToJavaStringHelper.isNullOrEmpty(serverIP)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: serverIP");
        }
        this._serverIP = serverIP;
        this._port = port;
        this._bindIP = bindingIP;
        this._traceProvider = traceProvider;
    }

    @Override
    public final String getName() {
        return this.privateName;
    }

    @Override
    public final void setName(String value) {
        this.privateName = value;
    }

    @Override
    public boolean getIsConnected() {
        return this._connection != null ? this._connection.getIsConnected() : false;
    }

    @Override
    public final boolean Connect() throws Exception {
        if (this._formatter == null) {
            throw new Exception("Channel formatter is not specified");
        }
        if (this._eventListener == null) {
            throw new Exception("There is no channel event listener specified");
        }
        try {
            if (this._connection == null) {
                this._connection = new TcpConnection();
                if (!DotNetToJavaStringHelper.isNullOrEmpty(this._bindIP)) {
                    this._connection.Bind(this._bindIP);
                }
                this._connection.Connect(this._serverIP, this._port);
                this._receiverThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TcpChannel.this.Run();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Logger.getLogger(GenericCopier.class.getName()).warning("UnsupportedEncodingException + " + unsupportedEncodingException.getMessage());
                        }
                    }
                });
                this._receiverThread.setDaemon(true);
                this._receiverThread.start();
                return true;
            }
        }
        catch (ConnectionException ce) {
            if (this._traceProvider != null) {
                this._traceProvider.TraceError(this.getName() + ".Connect", ce.toString());
            }
            throw new ChannelException(ce.getMessage(), ce);
        }
        return false;
    }

    @Override
    public final void Disconnect() {
        if (this._connection != null) {
            this._connection.Disconnect();
            if (this._receiverThread != null) {
                this.stopThread = true;
                this._receiverThread.interrupt();
            }
            this._connection = null;
        }
    }

    @Override
    public final boolean SendMessage(Object message) throws ChannelException, UnsupportedEncodingException {
        if (message == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: message");
        }
        byte[] serailizedMessage = null;
        try {
            serailizedMessage = this._formatter.Serialize(message);
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
        byte[] msgLength = ("" + serailizedMessage.length).getBytes("UTF-8");
        byte[] finalBuffer = null;
        try {
            finalBuffer = new byte[30 + serailizedMessage.length];
            System.arraycopy(msgLength, 0, finalBuffer, 20, msgLength.length);
            System.arraycopy(serailizedMessage, 0, finalBuffer, 30, serailizedMessage.length);
        }
        catch (Exception e) {
            Logger.getLogger(GenericCopier.class.getName()).warning("Exception + " + e.getMessage());
        }
        try {
            if (this.EnsureConnected()) {
                try {
                    this._connection.Send(finalBuffer, 0, finalBuffer.length);
                    return true;
                }
                catch (ConnectionException e) {
                    if (this.EnsureConnected()) {
                        this._connection.Send(finalBuffer, 0, finalBuffer.length);
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ChannelException(e.getMessage());
        }
        return false;
    }

    private boolean EnsureConnected() throws Exception {
        if (this._connection != null && !this._connection.getIsConnected()) {
            this.Disconnect();
            this.Connect();
        }
        return this._connection.getIsConnected();
    }

    @Override
    public final void RegisterEventListener(IChannelEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        this._eventListener = listener;
    }

    @Override
    public final void UnRegisterEventListener(IChannelEventListener listener) {
        if (listener != null && listener.equals(this._eventListener)) {
            this._eventListener = null;
        }
    }

    @Override
    public final IChannelFormatter getFormatter() {
        return this._formatter;
    }

    @Override
    public final void setFormatter(IChannelFormatter value) {
        this._formatter = value;
    }

    private void Run() throws UnsupportedEncodingException {
        while (!this.stopThread && !Thread.currentThread().isInterrupted()) {
            try {
                if (this._connection == null) continue;
                this._connection.Receive(this._sizeBuffer, 10);
                String resp = new String(this._sizeBuffer);
                int rspLength = Integer.parseInt(resp.trim());
                if (rspLength <= 0) continue;
                byte[] dataBuffer = new byte[rspLength];
                this._connection.Receive(dataBuffer, rspLength);
                IResponse response = null;
                if (this._formatter != null) {
                    Object tempVar = this._formatter.Deserialize(dataBuffer);
                    response = (IResponse)(tempVar instanceof IResponse ? tempVar : null);
                }
                if (this._eventListener == null) continue;
                this._eventListener.ReceiveResponse(response);
            }
            catch (ConnectionException ce) {
                if (this._traceProvider != null) {
                    this._traceProvider.TraceError(this.getName() + ".Run", ce.toString());
                }
                if (this._eventListener == null) break;
                this._eventListener.ChannelDisconnected(ce.getMessage());
                break;
            }
            catch (Exception e) {
                if (this._traceProvider == null) continue;
                this._traceProvider.TraceError(this.getName() + ".Run", e.toString());
            }
        }
    }
}

