/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Caching;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataReader.TwoDimensionalArray;
import Alachisoft.NCache.Common.DataStructures.VirtualArray;
import Alachisoft.NCache.Common.DataStructures.VirtualIndex;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LargeUserBinaryObject
extends UserBinaryObject {
    private int _index;
    private int _noOfChunks;
    private int _lastChunkSize;
    private ArrayList _data = new ArrayList();

    public static UserBinaryObject createUserBinaryObject(byte[] byteArray) {
        return null;
    }

    @Override
    public Object[] ClonePayload() {
        if (this._data == null || this.getLength() <= 0) {
            return null;
        }
        int i = 0;
        int numChunks = this._data.size();
        ArrayList<byte[]> clonedBuffers = new ArrayList<byte[]>(numChunks);
        for (i = 0; i < numChunks - 1; ++i) {
            if (!(this._data.get(i) instanceof byte[])) continue;
            byte[] clonedBuffer = new byte[((byte[])this._data.get(i)).length];
            System.arraycopy(this._data.get(i), 0, clonedBuffer, 0, ((byte[])this._data.get(i)).length);
            clonedBuffers.add(clonedBuffer);
        }
        if (this._data.get(i) instanceof byte[]) {
            byte[] clonedLastBuffer = new byte[this._lastChunkSize];
            System.arraycopy(this._data.get(i), 0, clonedLastBuffer, 0, this._lastChunkSize);
            clonedBuffers.add(clonedLastBuffer);
        }
        return clonedBuffers.toArray();
    }

    @Override
    public UserBinaryObject DeepClone() {
        return null;
    }

    @Override
    public VirtualArray Read(int offset, int length) {
        VirtualArray vBuffer = null;
        int streamLength = this.getLength();
        if (offset >= streamLength) {
            return new VirtualArray(0);
        }
        if (offset + length > streamLength) {
            length -= offset + length - streamLength;
        }
        VirtualArray vSrc = new VirtualArray(this._data);
        vBuffer = new VirtualArray(length);
        VirtualIndex vSrcIndex = new VirtualIndex(offset);
        VirtualIndex vDstIndex = new VirtualIndex();
        VirtualArray.CopyData(vSrc, vSrcIndex, vBuffer, vDstIndex, length);
        return vBuffer;
    }

    @Override
    public void Write(VirtualArray vBuffer, int srcOffset, int dstOffset, int length) {
        if (vBuffer == null) {
            return;
        }
        VirtualArray vDstArray = new VirtualArray(this._data);
        VirtualArray.CopyData(vBuffer, new VirtualIndex(srcOffset), vDstArray, new VirtualIndex(dstOffset), length, true);
        this._noOfChunks = this._data.size();
        this._lastChunkSize += (length < 0 ? 0 : length) % 80896;
    }

    private void addDataChunk(byte[] dataChunk) {
        if (this._data != null && this._index < this._noOfChunks) {
            this._data.add(this._index, dataChunk);
            ++this._index;
        }
    }

    @Override
    public List<byte[]> getDataList() {
        int i = 0;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>(this._noOfChunks);
        if (this.getLength() > 0) {
            for (i = 0; i < this._noOfChunks - 1; ++i) {
                byteList.add((byte[])this._data.get(i));
            }
            byte[] buffer = (byte[])this._data.get(i);
            if (buffer.length != this._lastChunkSize) {
                buffer = new byte[this._lastChunkSize];
                System.arraycopy((byte[])this._data.get(i), 0, buffer, 0, this._lastChunkSize);
            }
            byteList.add(buffer);
        }
        return byteList;
    }

    @Override
    public byte[] getFullObject() {
        byte[] fullByteArray = null;
        if (this.getLength() > 0) {
            fullByteArray = new byte[this.getLength()];
            int nextIndex = 0;
            byte[] binaryChunk = null;
            for (int i = 0; i < this._data.size() - 1; ++i) {
                binaryChunk = (byte[])this._data.get(i);
                if (binaryChunk == null) continue;
                System.arraycopy(binaryChunk, 0, fullByteArray, nextIndex, binaryChunk.length);
                nextIndex += binaryChunk.length;
            }
            System.arraycopy((byte[])this._data.get(this._noOfChunks - 1), 0, fullByteArray, nextIndex, this._lastChunkSize);
        }
        return fullByteArray;
    }

    @Override
    public byte[] getTwoDimensionalArray() {
        TwoDimensionalArray twoDimensionalArray = new TwoDimensionalArray(this.getLength());
        int nextIndex = 0;
        byte[] binarChunk = null;
        if (this.getLength() > 0) {
            for (int i = 0; i < this._data.size() - 1; ++i) {
                binarChunk = (byte[])this._data.get(i);
                if (binarChunk == null) continue;
                twoDimensionalArray.copyFromByteArray(binarChunk);
                nextIndex += binarChunk.length;
            }
            twoDimensionalArray.copyFromByteArray((byte[])this._data.get(this._noOfChunks - 1));
        }
        return twoDimensionalArray.toByteArray();
    }

    @Override
    public int getInMemorySize() {
        return this.getLength() + this._noOfChunks * 24;
    }

    @Override
    public int getLength() {
        return this._noOfChunks == 0 ? this._lastChunkSize : (this._noOfChunks - 1) * 80896 + this._lastChunkSize;
    }

    @Override
    public void setLength(int value) {
    }

    @Override
    public void initializeUserBinaryObject(Collection data) {
        this._noOfChunks = data.size();
        if (data instanceof List) {
            ByteString bs;
            int i;
            List buffers = (List)data;
            for (i = 0; i < buffers.size() && i < this._noOfChunks - 1; ++i) {
                bs = (ByteString)buffers.get(i);
                byte[] buffer = bs.toByteArray();
                this._data.add(buffer);
            }
            bs = (ByteString)buffers.get(i);
            byte[] lastBuffer = bs.toByteArray();
            this._lastChunkSize = bs.size();
            this._data.add(lastBuffer);
        } else {
            byte[] lastChunk;
            Iterator enumerator = data.iterator();
            for (int i = 0; enumerator.hasNext() && i < this._noOfChunks - 1; ++i) {
                byte[] chunk;
                byte[] buffer = chunk = (byte[])enumerator.next();
                this._data.add(buffer);
            }
            byte[] lastBuffer = lastChunk = (byte[])enumerator.next();
            this._lastChunkSize = lastChunk.length;
            this._data.add(lastBuffer);
        }
    }

    @Override
    public void initializeUserBinaryObject(byte[] data) {
        int noOfChunks;
        int nextChunk = 0;
        int nextChunkSize = 0;
        this._noOfChunks = noOfChunks += data.length - (noOfChunks = data.length / 80896) * 80896 != 0 ? 1 : 0;
        for (int i = 1; i <= noOfChunks - 1; ++i) {
            nextChunkSize = data.length - nextChunk;
            if (nextChunkSize > 80896) {
                nextChunkSize = 80896;
            }
            byte[] binaryChunk = new byte[nextChunkSize];
            System.arraycopy(data, nextChunk, binaryChunk, 0, nextChunkSize);
            this.addDataChunk(binaryChunk);
            nextChunk += nextChunkSize;
        }
        this._lastChunkSize = data.length - nextChunk;
        if (this._lastChunkSize > 80896) {
            this._lastChunkSize = 80896;
        }
        byte[] lastBinaryChunk = new byte[this._lastChunkSize];
        System.arraycopy(data, nextChunk, lastBinaryChunk, 0, this._lastChunkSize);
        this.addDataChunk(lastBinaryChunk);
    }

    @Override
    public void updateActualDataLength() {
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._lastChunkSize = reader.readInt();
        this._noOfChunks = reader.readInt();
        this._index = reader.readInt();
        if (this._noOfChunks > 0) {
            this._data = new ArrayList(this._noOfChunks);
            for (int i = 0; i < this._noOfChunks; ++i) {
                this._data.add(i, (byte[])reader.readObject());
            }
        }
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.write(this._lastChunkSize);
        writer.write(this._noOfChunks);
        writer.write(this._index);
        for (int i = 0; i < this._noOfChunks; ++i) {
            writer.writeObject(this._data.get(i));
        }
    }
}

