/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Storage;

import Alachisoft.NCache.Storage.StorageProviderBase;
import Alachisoft.NCache.Storage.StoreAddResult;
import Alachisoft.NCache.Storage.StoreInsResult;
import java.util.Iterator;

public class StorageProviderSyncWrapper
extends StorageProviderBase {
    protected StorageProviderBase _storage = null;

    public StorageProviderSyncWrapper(StorageProviderBase storageProvider) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: storageProvider");
        }
        this._storage = storageProvider;
        this._syncObj = this._storage.getSync();
    }

    @Override
    public void dispose() {
        if (this._storage != null) {
            this._storage.dispose();
            this._storage = null;
        }
        super.dispose();
    }

    @Override
    public long getMaxSize() {
        return this._storage.getMaxSize();
    }

    @Override
    public void setMaxSize(long value) {
        this._storage.setMaxSize(value);
    }

    @Override
    public long getMaxCount() {
        return super.getMaxCount();
    }

    @Override
    public void setMaxCount(long value) {
        super.setMaxCount(value);
    }

    @Override
    public long getCount() {
        this.getReadLock().lock();
        try {
            long l = this._storage.getCount();
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public long getSize() {
        this.getWriteLock().lock();
        try {
            long l = this._storage.getSize();
            return l;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public void Clear() {
        this.getWriteLock().lock();
        try {
            this._storage.Clear();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public boolean Contains(Object key) {
        this.getReadLock().lock();
        try {
            boolean bl = this._storage.Contains(key);
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public Object Get(Object key) {
        this.getReadLock().lock();
        try {
            Object object = this._storage.Get(key);
            return object;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public int GetItemSize(Object key) {
        this.getReadLock().lock();
        try {
            int n = this._storage.GetItemSize(key);
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreAddResult Add(Object key, Object item) {
        this.getWriteLock().lock();
        try {
            StoreAddResult storeAddResult = this._storage.Add(key, item);
            return storeAddResult;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreInsResult Insert(Object key, Object item) {
        this.getWriteLock().lock();
        try {
            StoreInsResult storeInsResult = this._storage.Insert(key, item);
            return storeInsResult;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public Object Remove(Object key) {
        this.getWriteLock().lock();
        try {
            Object object = this._storage.Remove(key);
            return object;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public Iterator GetEnumerator() {
        return this._storage.GetEnumerator();
    }

    @Override
    public Object[] getKeys() {
        this.getWriteLock().lock();
        try {
            Object[] objectArray = this._storage.getKeys();
            return objectArray;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

