/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Storage;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.ISizable;
import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Propagator.IAlertPropagator;
import Alachisoft.NCache.Storage.ICacheStorage;
import Alachisoft.NCache.Storage.StorageProviderSyncWrapper;
import Alachisoft.NCache.Storage.StoreAddResult;
import Alachisoft.NCache.Storage.StoreInsResult;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StorageProviderBase
implements ICacheStorage {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    protected final int DEFAULT_CAPACITY = 25000;
    protected final double DEFAULT_EXTRA_ACCOMDATION_PERCENTAGE = 0.2f;
    protected long _dataSize;
    protected ReentrantReadWriteLock _syncObj;
    protected Lock readLock;
    protected Lock writeLock;
    protected boolean _reportCacheNearEviction = false;
    protected int _evictionReportSize = 0;
    protected int _reportInterval = 5;
    protected Calendar _lastReportedTime = Calendar.getInstance();
    protected IAlertPropagator _alertPropagator;
    private String _cacheContext;
    private long _maxSize;
    private long _extraDataSize = 0L;
    private long _maxCount;
    private ILogger _ncacheLog;

    public StorageProviderBase() {
        this(0L);
    }

    public StorageProviderBase(long maxSize) {
        this._syncObj = new ReentrantReadWriteLock();
        this.readLock = this._syncObj.readLock();
        this.writeLock = this._syncObj.writeLock();
        this._maxSize = maxSize;
    }

    public StorageProviderBase(Map properties, boolean evictionEnabled) {
        this(properties, evictionEnabled, null, null);
    }

    public StorageProviderBase(Map properties, boolean evictionEnabled, ILogger NCacheLog, IAlertPropagator alertPropagator) {
        int interval;
        int size;
        this.Initialize(properties, evictionEnabled);
        this._ncacheLog = NCacheLog;
        this._alertPropagator = alertPropagator;
        String tmp = "";
        if (tmp != null && !tmp.equals("") && (size = Integer.parseInt(tmp)) > 0) {
            this._evictionReportSize = size;
            this._reportCacheNearEviction = true;
        }
        if ((tmp = "") != null && !tmp.equals("") && (interval = Integer.parseInt(tmp)) > 5) {
            this._reportInterval = interval;
        }
    }

    public static StorageProviderBase Synchronized(StorageProviderBase cacheStorage) {
        return new StorageProviderSyncWrapper(cacheStorage);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    public final ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    protected final void CheckForStoreNearEviction() {
        if (this._reportCacheNearEviction) {
            double currentSizeInPerc;
            this._lastReportedTime.add(12, this._reportInterval);
            if (this._lastReportedTime.getTimeInMillis() < System.currentTimeMillis() && this._maxSize > 0L && this._evictionReportSize > 0 && (currentSizeInPerc = (double)this._dataSize / (double)this._maxSize * 100.0) >= (double)this._evictionReportSize) {
                this._lastReportedTime.setTimeInMillis(System.currentTimeMillis());
            }
        }
    }

    private void InformCacheNearEviction(Object state) {
        try {
            long currentSizeInPerc = this._dataSize / this._maxSize * 100L;
            if (currentSizeInPerc > 100L) {
                currentSizeInPerc = 100L;
            }
            EventLogger.LogEvent((String)"NCache", (String)("Cache '" + this._cacheContext + "' has exceeded " + this._evictionReportSize + "% of allocated cache size"), (EventType)EventType.WARNING, (short)2, (int)1016);
            if (this._alertPropagator != null) {
                this._alertPropagator.RaiseAlert(1016, "NCache", "Cache '" + this._cacheContext + "' has exceeded " + this._evictionReportSize + "% of allocated cache size");
            }
            this.getNCacheLog().CriticalInfo("CacheStore", "cache has exceeded " + this._evictionReportSize + "% of allocated cache size");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public final void Initialize(Map properties, boolean evictionEnabled) {
        this._syncObj = new ReentrantReadWriteLock();
        this.readLock = this._syncObj.readLock();
        this.writeLock = this._syncObj.writeLock();
        if (properties == null) {
            return;
        }
        if (properties.containsKey("max-size")) {
            try {
                this._maxSize = this.ToBytes(Long.parseLong((String)properties.get("max-size")));
                if (properties.get("max-objects") != null) {
                    this._maxCount = Long.parseLong((String)properties.get("max-objects"));
                }
                if (evictionEnabled) {
                    this._extraDataSize = (long)((double)this._maxSize * (double)0.2f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long ToBytes(long mbytes) {
        return mbytes * 1024L * 1024L;
    }

    public void dispose() {
        this._syncObj = null;
        this.Cleared();
    }

    @Override
    public long getMaxSize() {
        return this._maxSize;
    }

    @Override
    public void setMaxSize(long value) {
        this._maxSize = value;
    }

    @Override
    public long getMaxCount() {
        return this._maxCount;
    }

    @Override
    public void setMaxCount(long value) {
        this._maxCount = value;
    }

    public final String getCacheContext() {
        return this._cacheContext;
    }

    public final void setCacheContext(String value) {
        this._cacheContext = value;
    }

    public final ReentrantReadWriteLock getSync() {
        return this._syncObj;
    }

    @Override
    public long getCount() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this._dataSize;
    }

    @Override
    public Object[] getKeys() {
        return null;
    }

    @Override
    public void Clear() {
    }

    @Override
    public boolean Contains(Object key) {
        return false;
    }

    @Override
    public Object Get(Object key) {
        return null;
    }

    @Override
    public int GetItemSize(Object key) {
        return 0;
    }

    @Override
    public StoreAddResult Add(Object key, Object item) {
        return StoreAddResult.Failure;
    }

    @Override
    public StoreInsResult Insert(Object key, Object item) {
        return StoreInsResult.Failure;
    }

    @Override
    public Object Remove(Object key) {
        return null;
    }

    @Override
    public Iterator GetEnumerator() {
        return null;
    }

    protected final StoreStatus HasSpace(ISizable item) {
        long nextSize = this._dataSize + (long)item.getSize();
        StoreStatus status = StoreStatus.HasSpace;
        if (nextSize > this._maxSize) {
            status = nextSize > this._maxSize + this._extraDataSize ? StoreStatus.HasNotEnoughSpace : StoreStatus.NearEviction;
        }
        return status;
    }

    protected final StoreStatus HasSpace(ISizable oldItem, ISizable newItem) {
        long nextSize = this._dataSize + (long)newItem.getSize() - (long)(oldItem == null ? 0 : oldItem.getSize());
        StoreStatus status = StoreStatus.HasSpace;
        if (nextSize > this._maxSize) {
            if (nextSize > this._maxSize + this._extraDataSize) {
                return StoreStatus.HasNotEnoughSpace;
            }
            return StoreStatus.NearEviction;
        }
        return status;
    }

    protected final void Added(ISizable item) {
        this._dataSize += (long)item.getSize();
    }

    protected final void Inserted(ISizable oldItem, ISizable newItem) {
        this._dataSize += (long)(newItem.getSize() - (oldItem == null ? 0 : oldItem.getSize()));
    }

    protected final void Removed(ISizable item) {
        this._dataSize -= (long)item.getSize();
    }

    protected final void Cleared() {
        this._dataSize = 0L;
    }

    protected static enum StoreStatus {
        HasSpace,
        NearEviction,
        HasNotEnoughSpace;


        public static StoreStatus forValue(int value) {
            return StoreStatus.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

