/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Storage.Interop;

import java.util.HashMap;

public enum Win32FileAttributes {
    FILE_ATTRIBUTE_READONLY(1),
    FILE_ATTRIBUTE_HIDDEN(2),
    FILE_ATTRIBUTE_SYSTEM(4),
    FILE_ATTRIBUTE_DIRECTORY(16),
    FILE_ATTRIBUTE_ARCHIVE(32),
    FILE_ATTRIBUTE_DEVICE(64),
    FILE_ATTRIBUTE_NORMAL(128),
    FILE_ATTRIBUTE_TEMPORARY(256),
    FILE_ATTRIBUTE_SPARSE_FILE(512),
    FILE_ATTRIBUTE_REPARSE_POINT(1024),
    FILE_ATTRIBUTE_COMPRESSED(2048),
    FILE_ATTRIBUTE_OFFLINE(4096),
    FILE_ATTRIBUTE_NOTCONTENTINDEXED(8192),
    FILE_ATTRIBUTE_ENCRYPTED(16384);

    private static HashMap<Integer, Win32FileAttributes> mappings;
    private int intValue;

    private Win32FileAttributes(int value) {
        this.intValue = value;
        Win32FileAttributes.getMappings().put(value, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, Win32FileAttributes> getMappings() {
        if (mappings != null) return mappings;
        Class<Win32FileAttributes> clazz = Win32FileAttributes.class;
        synchronized (Win32FileAttributes.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    public static Win32FileAttributes forValue(int value) {
        return Win32FileAttributes.getMappings().get(value);
    }

    public int getValue() {
        return this.intValue;
    }
}

