/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypeInfoMap {
    StringBuilder _protocolString = null;
    private int _typeHandle = 0;
    private HashMap _map;
    private HashMap _typeToHandleMap;

    public TypeInfoMap(String protocolString) {
        this.createMap(protocolString);
    }

    public TypeInfoMap(HashMap protocolMap) {
        this.createMap(protocolMap);
    }

    public final String ToProtocolString() {
        this._protocolString = new StringBuilder();
        this._protocolString.append(this._map.size()).append("\"");
        for (Map.Entry pair : this._map.entrySet()) {
            this._protocolString.append((Integer)pair.getKey()).append("\"");
            HashMap type = pair.getValue() instanceof HashMap ? pair.getValue() : null;
            this._protocolString.append((String)(type.get("name") instanceof String ? type.get("name") : null)).append("\"");
            ArrayList attributes = (ArrayList)type.get("sequence");
            this._protocolString.append(attributes.size()).append("\"");
            for (int i = 0; i < attributes.size(); ++i) {
                this._protocolString.append((String)(attributes.get(i) instanceof String ? attributes.get(i) : null)).append("\"");
            }
        }
        return this._protocolString.toString();
    }

    private void createMap(HashMap indexClasses) {
        this._map = new HashMap();
        this._typeToHandleMap = new HashMap();
        for (Map.Entry ie : indexClasses.entrySet()) {
            HashMap innerProps = ie.getValue() instanceof HashMap ? (HashMap)ie.getValue() : null;
            if (innerProps == null) continue;
            HashMap<String, Object> type = new HashMap<String, Object>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            ArrayList<String> attribList = new ArrayList<String>();
            for (Map.Entry en : innerProps.entrySet()) {
                HashMap attribs = en.getValue() instanceof HashMap ? (HashMap)en.getValue() : null;
                if (attribs == null) continue;
                for (Map.Entry ide : attribs.entrySet()) {
                    HashMap attrib = ide.getValue() instanceof HashMap ? (HashMap)ide.getValue() : null;
                    if (attrib == null) continue;
                    attribList.add(attrib.get("id") instanceof String ? (String)attrib.get("id") : null);
                    attributes.put(attrib.get("id") instanceof String ? (String)attrib.get("id") : null, attrib.get("data-type") instanceof String ? (String)attrib.get("data-type") : null);
                }
            }
            type.put("name", innerProps.get("name") instanceof String ? (String)innerProps.get("name") : null);
            type.put("attributes", attributes);
            type.put("sequence", attribList);
            this._map.put(this._typeHandle, type);
            this._typeToHandleMap.put(type.get("name") instanceof String ? (String)type.get("name") : null, this._typeHandle);
            ++this._typeHandle;
        }
    }

    private void createMap(String value) {
        int startIndex = 0;
        int endIndex = value.indexOf(34, startIndex + 1);
        int typeCount = Integer.parseInt(value.substring(startIndex, endIndex));
        this._map = new HashMap(typeCount);
        this._typeToHandleMap = new HashMap(typeCount);
        for (int i = 0; i < typeCount; ++i) {
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            int typeHandle = Integer.parseInt(value.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            String typeName = value.substring(startIndex, endIndex);
            HashMap<String, Object> typeMap = new HashMap<String, Object>();
            typeMap.put("name", typeName);
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            int attributesCount = Integer.parseInt(value.substring(startIndex, endIndex));
            ArrayList<String> attributes = new ArrayList<String>(attributesCount);
            for (int j = 0; j < attributesCount; ++j) {
                startIndex = endIndex + 1;
                endIndex = value.indexOf(34, endIndex + 1);
                String attributeName = value.substring(startIndex, endIndex);
                attributes.add(attributeName);
            }
            typeMap.put("sequence", attributes);
            this._map.put(typeHandle, typeMap);
            this._typeToHandleMap.put((String)typeMap.get("name"), typeHandle);
        }
    }

    public String getTypeName(int handle) {
        return (String)((HashMap)this._map.get(handle)).get("name");
    }

    public HashMap getAttributes(int handle) {
        return (HashMap)((HashMap)this._map.get(handle)).get("attributes");
    }

    public HashMap getAttributes(String typeName) {
        int handle = this.getHandleId(typeName);
        if (handle != -1 && this._map.containsKey(handle)) {
            return (HashMap)((HashMap)this._map.get(handle)).get("attributes");
        }
        return null;
    }

    public ArrayList getAttribList(int handle) {
        return (ArrayList)((HashMap)this._map.get(handle)).get("sequence");
    }

    public int getHandleId(String typeName) {
        if (this._typeToHandleMap.containsKey(typeName)) {
            return (Integer)this._typeToHandleMap.get(typeName);
        }
        return -1;
    }
}

