/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.util;

import com.alachisoft.ncache.runtime.JSON.JsonObject;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.CompactSerializationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.JSON.JsonBinaryFormatter;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import com.alachisoft.ncache.serialization.standard.io.ObjectInputStream;
import com.alachisoft.ncache.serialization.standard.io.ObjectOutputStream;
import com.alachisoft.ncache.serialization.util.ClassInfoPool;
import com.alachisoft.ncache.serialization.util.SerializationBitSet;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SerializationUtil {
    public static short userdefinedArrayTypeHandle = (short)5000;
    static HashMap _attributeOrder = new HashMap();
    static HashMap _portibilaty = new HashMap();
    static HashMap _subTypeHandle = new HashMap();
    private static FormatterServices impl = null;
    private static List cacheList;
    private static HashMap typeInfoMapTable;
    private static ClassInfoPool classInfoPool;

    public static void initialize(String compactTypeInfoString, String cacheContext) throws Exception {
        impl = FormatterServices.getDefault();
        HashMap type = SerializationUtil.GetTypeMapFromProtocolString(compactTypeInfoString, new int[1], new int[1]);
        HashMap compactType = SerializationUtil.getCompactTypes(type, false, cacheContext);
        if (!(compactType == null || compactType.isEmpty() && compactType.size() == 0)) {
            impl.register(compactType, SerializationUtil.getAttributeOrder(cacheContext), cacheContext, SerializationUtil.getPortability(cacheContext));
        }
        if (cacheList == null) {
            cacheList = new ArrayList();
        }
        if (!cacheList.contains(cacheContext)) {
            cacheList.add(cacheContext);
        }
    }

    public static byte[] safeSerialize(Object value, String cacheContext, SerializationBitSet flag) throws IOException {
        if (value instanceof byte[] && flag != null) {
            flag.SetBit((byte)-128);
            return (byte[])value;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream((OutputStream)byteArrayOutputStream, cacheContext);
        objectOutput.writeObject(value);
        objectOutput.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object safeDeserialize(Object value, String cacheContext, SerializationBitSet flag) throws IOException, ClassNotFoundException {
        if (value != null && value instanceof byte[]) {
            if (flag != null && flag.IsBitSet((byte)-128)) {
                return value;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])value);
            ObjectInputStream objectInput = new ObjectInputStream((InputStream)byteArrayInputStream, cacheContext);
            return objectInput.readObject();
        }
        return value;
    }

    public static Object compactSerialize(Object value, String cacheContext) throws IOException {
        if (value != null && value instanceof ICompactSerializable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream((OutputStream)byteArrayOutputStream, cacheContext);
            objectOutput.writeObject(value);
            objectOutput.flush();
            return byteArrayOutputStream.toByteArray();
        }
        return value;
    }

    public static void unRegisterCache(String cacheContext) {
        if (cacheList != null && cacheList.contains(cacheContext)) {
            impl.unregisterKnownType(null, cacheContext, true);
            cacheList.remove(cacheContext);
        } else {
            if (impl == null) {
                impl = FormatterServices.getDefault();
            }
            impl.unregisterKnownType(null, cacheContext, true);
        }
    }

    public static HashMap getCompactTypes(Map typeInfo, boolean throwExceptions, String cacheContext) throws CompactSerializationException, Exception {
        Object typeName = "";
        short typeHandle = 0;
        HashMap types = null;
        Object knownTypes = null;
        HashMap framework = new HashMap();
        HashMap<Object, String[][]> typeTable = new HashMap<Object, String[][]>();
        HashMap<Short, Boolean> portability = new HashMap<Short, Boolean>();
        Iterator ide = typeInfo.entrySet().iterator();
        try {
            while (ide.hasNext()) {
                Map.Entry pairs = ide.next();
                HashMap info = (HashMap)pairs.getValue();
                if (info == null) continue;
                Class<?> type = null;
                typeHandle = (short)Integer.parseInt((String)pairs.getKey());
                for (Map.Entry pairs2 : info.entrySet()) {
                    boolean portable;
                    HashMap attributeOrder;
                    block27: {
                        if (!(pairs.getValue() instanceof HashMap) || !(types = (HashMap)pairs2.getValue()).containsKey("name") || !types.get("type").toString().toLowerCase().equals("java")) continue;
                        typeName = (String)types.get("name");
                        attributeOrder = (HashMap)types.get("attribute");
                        portable = false;
                        try {
                            portable = Boolean.parseBoolean((String)types.get("portable"));
                        }
                        catch (Exception ex) {
                            portable = false;
                        }
                        String[] typeNameArray = null;
                        if (portable) {
                            typeNameArray = ((String)typeName).split(":");
                            typeName = typeNameArray[0];
                            for (int i = 1; i < typeNameArray.length - 1; ++i) {
                                typeName = (String)typeName + "." + typeNameArray[i];
                            }
                        }
                        try {
                            type = null;
                            type = Class.forName((String)typeName);
                            String ImplementationVersion = "";
                            if (portable) {
                                String SpecificationVersion = "";
                                String className = type.getSimpleName() + ".class";
                                String classPath = type.getResource(className).toString();
                                if (classPath.startsWith("jar")) {
                                    String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
                                    Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                                    Attributes attr = manifest.getMainAttributes();
                                    Attributes.Name Implementation = new Attributes.Name("Implementation-Version");
                                    Attributes.Name Specification = new Attributes.Name("Specification-Version");
                                    if (attr.get(Implementation) != null) {
                                        ImplementationVersion = (String)attr.get(Implementation);
                                    }
                                    if (attr.get(Specification) != null) {
                                        SpecificationVersion = (String)attr.get(Specification);
                                    }
                                    String version = typeNameArray[typeNameArray.length - 1];
                                    if (!(typeNameArray == null || version.equals("0.0") || ImplementationVersion.equals(version) || SpecificationVersion.equals(version))) {
                                        type = null;
                                        throw new Exception("ImplementationVersion or SpecificationVersion does not match");
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!throwExceptions) break block27;
                            throw new CompactSerializationException(e.getMessage());
                        }
                    }
                    if (type == null) continue;
                    HashMap<String, Short> handleNonCompactFieldsMap = new HashMap<String, Short>();
                    handleNonCompactFieldsMap.put("handle", typeHandle);
                    if (types.containsKey("non-compact-fields")) {
                        handleNonCompactFieldsMap.put("non-compact-fields", (Short)types.get("non-compact-fields"));
                    }
                    framework.put(type, handleNonCompactFieldsMap);
                    HashMap attributeUnion = null;
                    HashMap[] orderedUnion = null;
                    if (portable) {
                        attributeUnion = (HashMap)info.get("Alachisoft.NCache.AttributeUnion");
                        orderedUnion = new HashMap[((HashMap)attributeUnion.get("attribute")).size()];
                        if (attributeUnion != null && attributeUnion.get("attribute") != null) {
                            for (Map.Entry p : ((HashMap)attributeUnion.get("attribute")).entrySet()) {
                                HashMap attribute = (HashMap)p.getValue();
                                int order = Integer.parseInt((String)attribute.get("order"));
                                orderedUnion[order - 1] = attribute;
                            }
                        }
                    }
                    if (attributeOrder != null && attributeOrder.size() > 0 && portable) {
                        String[][] temp = new String[][]{new String[orderedUnion.length], new String[orderedUnion.length]};
                        HashMap[] attributearray = attributeOrder.values().toArray(new HashMap[attributeOrder.size()]);
                        ArrayList<HashMap> attributeList = new ArrayList<HashMap>();
                        attributeList.addAll(Arrays.asList(attributearray));
                        HashMap toRemove = null;
                        for (int count = 0; count < orderedUnion.length; ++count) {
                            String attrib = (String)orderedUnion[count].get("order");
                            for (int i = 0; i < attributeList.size(); ++i) {
                                HashMap attribute = (HashMap)attributeList.get(i);
                                if (!attrib.equals((String)attribute.get("order"))) continue;
                                temp[0][count] = (String)attribute.get("name");
                                if (attribute.get("type").toString().contains("unsigned")) {
                                    temp[0][count] = attribute.get("type").toString() + "." + temp[0][count];
                                }
                                temp[1][count] = String.valueOf(count + 1);
                                toRemove = attribute;
                                break;
                            }
                            if (toRemove != null) {
                                attributeList.remove(toRemove);
                                toRemove = null;
                            }
                            if (temp[0][count] != null) continue;
                            temp[0][count] = "skip.attribute";
                            temp[1][count] = "0";
                        }
                        if (attributeList != null && attributeList.size() > 0) {
                            int i;
                            String[][] temporary = new String[2][];
                            temporary = (String[][])temp.clone();
                            temp[0] = new String[((HashMap)attributeUnion.get("attribute")).size() + attributeList.size()];
                            temp[1] = new String[((HashMap)attributeUnion.get("attribute")).size() + attributeList.size()];
                            for (i = 0; i < temporary[0].length; ++i) {
                                temp[0][i] = temporary[0][i];
                                temp[1][i] = temporary[1][i];
                            }
                            for (i = temporary[0].length; i < temporary[0].length + attributeList.size(); ++i) {
                                temp[0][i] = (String)((HashMap)attributeList.toArray()[i - temporary[0].length]).get("name");
                                temp[1][i] = "-1";
                            }
                        }
                        if (SerializationUtil.CheckAlreadyRegistered(portable, cacheContext, (String)pairs.getKey(), type, (String)typeName)) continue;
                        typeTable.put(typeName, temp);
                        _attributeOrder.put(cacheContext, typeTable);
                        portability.put(Short.parseShort((String)pairs.getKey()), portable);
                        _portibilaty.put(cacheContext, portability);
                        SerializationUtil.PopulateSubHandle(portable, cacheContext, (String)pairs.getKey(), (String)types.get("handle-id"), type);
                        continue;
                    }
                    if (SerializationUtil.CheckAlreadyRegistered(portable, cacheContext, (String)pairs.getKey(), type, (String)typeName)) continue;
                    typeTable.put(typeName, null);
                    _attributeOrder.put(cacheContext, typeTable);
                    portability.put(Short.parseShort((String)pairs.getKey()), portable);
                    _portibilaty.put(cacheContext, portability);
                    SerializationUtil.PopulateSubHandle(portable, cacheContext, (String)pairs.getKey(), (String)types.get("handle-id"), type);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return framework;
    }

    public static short getSubTypeHandle(String cacheContext, String handle, Class type) {
        if (_subTypeHandle == null) {
            return 0;
        }
        if (!_subTypeHandle.containsKey(cacheContext)) {
            return 0;
        }
        if (!((HashMap)_subTypeHandle.get(cacheContext)).containsKey(handle)) {
            return 0;
        }
        return Short.parseShort((String)((HashMap)((HashMap)_subTypeHandle.get(cacheContext)).get(handle)).get(type));
    }

    private static boolean CheckAlreadyRegistered(boolean portable, String cacheContext, String handle, Class type, String typeName) {
        return portable ? _subTypeHandle.containsKey(cacheContext) && ((HashMap)_subTypeHandle.get(cacheContext.toLowerCase())).containsKey(handle) && ((HashMap)((HashMap)_subTypeHandle.get(cacheContext.toLowerCase())).get(handle)).containsKey(type) : _attributeOrder.containsKey(cacheContext.toLowerCase()) && ((HashMap)_attributeOrder.get(cacheContext.toLowerCase())).containsKey(typeName);
    }

    public static HashMap GetTypeMapFromProtocolString(String protocolString, int[] startIndex, int[] endIndex) {
        endIndex[0] = protocolString.indexOf("\"", startIndex[0] + 1);
        HashMap<String, Object> tbl = new HashMap<String, Object>();
        String token = protocolString.substring(startIndex[0], endIndex[0]);
        if (token.equals("__dictionary")) {
            startIndex[0] = endIndex[0] + 1;
            endIndex[0] = protocolString.indexOf("\"", endIndex[0] + 1);
            int dicCount = Integer.parseInt(protocolString.substring(startIndex[0], endIndex[0]));
            for (int i = 0; i < dicCount; ++i) {
                startIndex[0] = endIndex[0] + 1;
                endIndex[0] = protocolString.indexOf("\"", endIndex[0] + 1);
                String key = protocolString.substring(startIndex[0], endIndex[0]);
                startIndex[0] = endIndex[0] + 1;
                endIndex[0] = protocolString.indexOf("\"", endIndex[0] + 1);
                String value = protocolString.substring(startIndex[0], endIndex[0]);
                if (value.equals("__dictionary")) {
                    HashMap temp = new HashMap();
                    temp = SerializationUtil.GetTypeMapFromProtocolString(protocolString, startIndex, endIndex);
                    tbl.put(key, temp);
                    continue;
                }
                tbl.put(key, value);
            }
        }
        return tbl;
    }

    public static String GetProtocolStringFromTypeMap(HashMap typeMap) {
        Stack<Object> st = new Stack<Object>();
        StringBuilder protocolString = new StringBuilder();
        protocolString.append("__dictionary").append("\"");
        protocolString.append(typeMap.size()).append("\"");
        for (Map.Entry mapDic : typeMap.entrySet()) {
            if (mapDic.getValue() instanceof HashMap) {
                st.push(mapDic.getValue());
                st.push(mapDic.getKey());
                continue;
            }
            protocolString.append(mapDic.getKey()).append("\"");
            protocolString.append(mapDic.getValue()).append("\"");
        }
        while (st.size() != 0 && st.size() % 2 == 0) {
            Object obj1 = st.pop();
            protocolString.append(obj1 instanceof String ? obj1.toString() : "").append("\"");
            Object obj2 = st.pop();
            protocolString.append(SerializationUtil.GetProtocolStringFromTypeMap(obj2 instanceof HashMap ? (HashMap)obj2 : null));
        }
        return protocolString.toString();
    }

    public static HashMap getAttributeOrder(String cacheContext) {
        return (HashMap)_attributeOrder.get(cacheContext);
    }

    public static HashMap getPortability(String cacheContext) {
        return (HashMap)_portibilaty.get(cacheContext);
    }

    public static boolean getPortability(short type, String cacheContext) {
        return (Boolean)((HashMap)_portibilaty.get(cacheContext)).get(type);
    }

    public static void PopulateSubHandle(boolean portable, String cacheContext, String handle, String subHandle, Class type) {
        if (portable) {
            if (!_subTypeHandle.containsKey(cacheContext)) {
                _subTypeHandle.put(cacheContext, new HashMap());
            }
            if (!((HashMap)_subTypeHandle.get(cacheContext)).containsKey(handle)) {
                ((HashMap)_subTypeHandle.get(cacheContext)).put(handle, new HashMap());
            }
            if (!((HashMap)((HashMap)_subTypeHandle.get(cacheContext)).get(handle)).containsKey(type)) {
                ((HashMap)((HashMap)_subTypeHandle.get(cacheContext)).get(handle)).put(type, subHandle);
            } else {
                throw new IllegalArgumentException("Sub-Handle '" + subHandle + "' already present in " + cacheContext + " in class " + type.getName() + " with Handle " + handle);
            }
        }
    }

    public static short GetSubTypeHandle(String cacheContext, String handle, Class type) {
        if (!_subTypeHandle.containsKey(cacheContext)) {
            return 0;
        }
        if (!((HashMap)_subTypeHandle.get(cacheContext)).containsKey(handle)) {
            return 0;
        }
        return Short.parseShort((String)((HashMap)((HashMap)_subTypeHandle.get(cacheContext)).get(handle)).get(type));
    }

    public static void registerTypeInfoMap(String cacheContext, TypeInfoMap typeInfoMap) {
        classInfoPool = new ClassInfoPool();
        if (!typeInfoMapTable.containsKey(cacheContext)) {
            typeInfoMapTable.put(cacheContext, typeInfoMap);
        }
    }

    public static void UnRegisterTypeInfoMap(String cacheContext) {
        if (!typeInfoMapTable.containsKey(cacheContext)) {
            typeInfoMapTable.remove(cacheContext);
        }
    }

    public static HashMap getQueryInfo(Object value, String cacheContext) throws Exception {
        TypeInfoMap typeInfoMap = (TypeInfoMap)typeInfoMapTable.get(cacheContext);
        if (typeInfoMap == null) {
            return null;
        }
        return SerializationUtil.getQueryInfo(value, typeInfoMap);
    }

    public static HashMap getQueryInfo(Object value, TypeInfoMap typeMap) throws Exception {
        HashMap queryInfo = null;
        if (typeMap == null) {
            return null;
        }
        try {
            int handleId;
            JsonObject jsonObject;
            String typeName = value.getClass().getCanonicalName();
            boolean isJson = false;
            if (JsonObject.class.isAssignableFrom(value.getClass()) && (jsonObject = (JsonObject)value).getType() != null && !jsonObject.getType().isEmpty()) {
                typeName = jsonObject.getType();
                isJson = true;
            }
            if ((handleId = typeMap.getHandleId(typeName)) != -1) {
                queryInfo = new HashMap();
                ArrayList<Object> attribValues = new ArrayList<Object>();
                ArrayList attributes = typeMap.getAttribList(handleId);
                for (int i = 0; i < attributes.size(); ++i) {
                    if (!isJson) {
                        Field fieldAttrib = value.getClass().getDeclaredField((String)attributes.get(i));
                        if (fieldAttrib != null) {
                            fieldAttrib.setAccessible(true);
                            Object attribValue = fieldAttrib.get(value);
                            if (attribValue instanceof String) {
                                attribValue = attribValue.toString().toLowerCase();
                            }
                            attribValues.add(attribValue);
                            continue;
                        }
                        throw new Exception("Unable to extract query information from user object.");
                    }
                    JsonObject jsonObject2 = (JsonObject)value;
                    JsonValue jsonValue = (JsonValue)jsonObject2.getAttributeValue((String)attributes.get(i));
                    if (jsonValue != null) {
                        attribValues.add(jsonValue.getValue());
                        continue;
                    }
                    throw new Exception("Unable to extract query information from user object for attribute \"" + (String)attributes.get(i) + "\"");
                }
                queryInfo.put((CallSite)((Object)("" + handleId)), attribValues);
            }
        }
        catch (Exception e) {
            throw new GeneralFailureException(e.getMessage());
        }
        return queryInfo;
    }

    public static byte[] serializeDataStructureItem(Object serializableObject) {
        JsonValueBase possibleJsonValue;
        String json = new String();
        JsonValueBase jsonValueBase = possibleJsonValue = serializableObject instanceof JsonValueBase ? (JsonValueBase)serializableObject : null;
        if (possibleJsonValue != null) {
            json = possibleJsonValue.toString();
        } else {
            try {
                json = JsonBinaryFormatter.serializeObject(serializableObject, false);
            }
            catch (OperationFailedException e) {
                return null;
            }
        }
        return json.getBytes(JsonBinaryFormatter.SERIALIZATION_CHARSET);
    }

    static {
        typeInfoMapTable = new HashMap();
    }
}

