/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;

public class UInt32ArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public UInt32ArraySerializationSurrogate() {
        super(UInt32ArraySerializationSurrogate.class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new long[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            long[] longValue = (long[])graph;
            for (int i = 0; i < longValue.length; ++i) {
                longValue[i] = input.readUInt32();
            }
            return longValue;
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            long[] longValue = (long[])graph;
            output.writeInt(longValue.length);
            for (int i = 0; i < longValue.length; ++i) {
                output.writeUInt32(longValue[i]);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            long[] longValue = (long[])graph;
            for (int i = 0; i < longValue.length; ++i) {
                input.skipUInt32();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

