/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.BlockDataInputStream;
import com.alachisoft.ncache.serialization.core.io.BlockDataOutputStream;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;
import java.io.IOException;

public class StringSerializationSurrogate
extends SerializationSurrogateBase
implements SerializationSurrogate,
BuiltinSerializationSurrogate {
    public StringSerializationSurrogate() {
        super(String.class);
    }

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        BlockDataInputStream bin = (BlockDataInputStream)input.getContext().getUserItem("__bin");
        try {
            if (bin != null) {
                return bin.readUTF();
            }
            return input.readUTF();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        BlockDataOutputStream bout = (BlockDataOutputStream)output.getContext().getUserItem("__bout");
        try {
            if (bout != null) {
                bout.writeUTF((String)graph);
            } else {
                output.writeUTF((String)graph);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            input.skipUTF();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

