/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;

public class StringArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public StringArraySerializationSurrogate() {
        super(String[].class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new String[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            String[] array = (String[])graph;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (input.readShort() != 1) continue;
                array[i] = input.readUTF();
            }
            return array;
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            String[] array = (String[])graph;
            int len = array.length;
            output.writeInt(len);
            for (int i = 0; i < len; ++i) {
                if (array[i] != null) {
                    output.writeShort(1);
                    output.writeUTF(array[i]);
                    continue;
                }
                output.writeShort(0);
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        try {
            String[] array = (String[])graph;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                input.skipShort();
                input.skipUTF();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

