/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateBase;
import java.io.IOException;

public class EnumSerializationSurrogate
extends SerializationSurrogateBase
implements SerializationSurrogate,
BuiltinSerializationSurrogate {
    public EnumSerializationSurrogate(Class type) {
        super(type);
    }

    @Override
    public Object readObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            String enumConst = input.readUTF();
            return Enum.valueOf(this.getRealClass(), enumConst);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void writeObject(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            output.writeUTF(((Enum)graph).name());
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    @Override
    public void skipObject(NCacheObjectInput input) throws NCacheInstantiationException, NCacheIOException {
        try {
            input.skipUTF();
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

