/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io.surrogates;

import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogateImpl;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DateArraySerializationSurrogate
extends SerializationSurrogateImpl
implements BuiltinSerializationSurrogate {
    public DateArraySerializationSurrogate() {
        super(Date[].class);
    }

    @Override
    public Object instantiate(NCacheObjectInput input) throws NCacheInstantiationException {
        try {
            int length = input.readInt();
            return new Date[length];
        }
        catch (IOException ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    @Override
    public Object readDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        Date[] array = (Date[])graph;
        int len = array.length;
        try {
            for (int i = 0; i < len; ++i) {
                array[i] = new NCDateTime(input.readLong()).getDate();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        return array;
    }

    @Override
    public void writeDirect(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        Date[] array = (Date[])graph;
        int len = array.length;
        try {
            output.writeInt(len);
            for (int i = 0; i < len; ++i) {
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(14, 0);
                c.setTime(array[i]);
                NCDateTime ncdt = new NCDateTime(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
                output.writeLong(ncdt.getTicks());
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
        catch (IllegalArgumentException arg) {
            throw new NCacheIOException(arg);
        }
    }

    @Override
    public void skipDirect(NCacheObjectInput input, Object graph) throws NCacheInstantiationException, NCacheIOException {
        Date[] array = (Date[])graph;
        int len = array.length;
        try {
            for (int i = 0; i < len; ++i) {
                array[i] = new NCDateTime(input.readLong()).getDate();
            }
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

