/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io;

import com.alachisoft.ncache.serialization.core.io.BlockDataInputStream;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.SerializationContext;
import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.TypeSurrogateSelectorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ObjectInputStream
extends InputStream
implements NCacheObjectInput {
    public static byte[] buf;
    private BlockDataInputStream mInput;
    private SerializationContext mContext;
    private TypeSurrogateSelector mSelector;
    private String _cacheContext;

    public ObjectInputStream(InputStream in, String cacheContext) throws IOException {
        this.mInput = new BlockDataInputStream(in);
        this.mContext = new SerializationContext(TypeSurrogateSelectorImpl.getDefault());
        this.mSelector = this.mContext.getSurrogateSelector();
        this.mContext.putUserItem("__bin", this.mInput);
        this._cacheContext = cacheContext;
    }

    public ObjectInputStream(InputStream in, TypeSurrogateSelector selector) throws IOException {
        this.mInput = new BlockDataInputStream(in);
        this.mSelector = TypeSurrogateSelectorImpl.getDefault();
        this.mContext = new SerializationContext(this.mSelector);
        this.mContext.putUserItem("__bin", this.mInput);
    }

    @Override
    public SerializationContext getContext() {
        return this.mContext;
    }

    @Override
    public InputStream getBaseStream() {
        return this.mInput;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.mInput.readFully(b);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.mInput.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.mInput.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.mInput.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.mInput.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.mInput.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this.mInput.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.mInput.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this.mInput.readUTF8Char();
    }

    @Override
    public final int readInt() throws IOException {
        return this.mInput.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.mInput.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.mInput.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.mInput.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.mInput.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.mInput.readUTF();
    }

    @Override
    public int readUInt16() throws IOException {
        return this.mInput.readUInt16();
    }

    @Override
    public long readUInt32() throws IOException {
        return this.mInput.readUInt32();
    }

    @Override
    public BigInteger readUInt64() throws IOException {
        return this.mInput.readUInt64();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        try {
            short handle = this.readShort();
            SerializationSurrogate surrogate = this.mSelector.getSurrogateForTypeHandle(handle, this._cacheContext);
            if (surrogate == null) {
                surrogate = this.mSelector.GetSurrogateForSubTypeHandle(handle, this.readShort(), this._cacheContext);
            }
            return surrogate.readObject(this);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public Object readObjectAs(Class objClass) throws ClassNotFoundException, IOException {
        try {
            SerializationSurrogate surrogate = this.mSelector.getSurrogateForType(objClass, this._cacheContext);
            return surrogate.readObject(this);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public final int read() throws IOException {
        return this.mInput.read();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.mInput.read(b);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.mInput.read(b, off, len);
    }

    @Override
    public final long skip(long n) throws IOException {
        return this.mInput.skip(n);
    }

    @Override
    public final int available() throws IOException {
        return this.mInput.available();
    }

    @Override
    public final void close() throws IOException {
        this.mInput.close();
    }

    @Override
    public String getCacheContext() {
        return this._cacheContext;
    }

    @Override
    public void skipObject() throws IOException {
        try {
            short handle = this.readShort();
            SerializationSurrogate surrogate = this.mSelector.getSurrogateForTypeHandle(handle, this._cacheContext);
            if (surrogate == null) {
                surrogate = this.mSelector.GetSurrogateForSubTypeHandle(handle, this.readShort(), this._cacheContext);
            }
            surrogate.skipObject(this);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public void skipFully(byte[] b) throws IOException {
        this.mInput.skipBytes(b.length);
    }

    @Override
    public void skipFully(byte[] b, int off, int len) throws IOException {
        this.mInput.readFully(b, off, len);
    }

    @Override
    public void skipBoolean() throws IOException {
        this.mInput.skipBytes(1);
    }

    @Override
    public void skipByte() throws IOException {
        this.mInput.skipBytes(1);
    }

    @Override
    public void skipUnsignedByte() throws IOException {
        this.mInput.skipBytes(1);
    }

    @Override
    public void skipShort() throws IOException {
        this.mInput.skipBytes(2);
    }

    @Override
    public void skipUnsignedShort() throws IOException {
        this.mInput.skipBytes(2);
    }

    @Override
    public void skipChar() throws IOException {
        this.mInput.skipBytes(1);
    }

    @Override
    public void skipInt() throws IOException {
        this.mInput.skipBytes(4);
    }

    @Override
    public void skipLong() throws IOException {
        this.mInput.skipBytes(8);
    }

    @Override
    public void skipFloat() throws IOException {
        this.mInput.skipBytes(4);
    }

    @Override
    public void skipDouble() throws IOException {
        this.mInput.skipBytes(8);
    }

    @Override
    public void skipLine() throws IOException {
        this.mInput.readLine();
    }

    @Override
    public void skipUTF() throws IOException {
        this.mInput.readUTF();
    }

    @Override
    public void skipUInt16() throws IOException {
        this.mInput.skipBytes(2);
    }

    @Override
    public void skipUInt32() throws IOException {
        this.mInput.skipBytes(4);
    }

    @Override
    public void skipUInt64() throws IOException {
        this.mInput.skipBytes(8);
    }

    @Override
    public void skipUByte() throws IOException {
        this.mInput.skipBytes(2);
    }

    @Override
    public short readUByte() throws IOException {
        return this.mInput.readUByte();
    }
}

